/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.exec;

import ratpack.exec.ExecController;
import ratpack.exec.ExecResult;
import ratpack.exec.ExecStarter;
import ratpack.exec.Execution;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.registry.RegistrySpec;
import ratpack.test.exec.internal.DefaultExecHarness;

public interface ExecHarness
extends AutoCloseable {
    public static ExecHarness harness() {
        return new DefaultExecHarness((ExecController)new DefaultExecController());
    }

    public static ExecHarness harness(int numThreads) {
        return new DefaultExecHarness((ExecController)new DefaultExecController(numThreads));
    }

    default public ExecStarter fork() {
        return this.getController().fork();
    }

    public ExecController getController();

    default public <T> ExecResult<T> yield(Function<? super Execution, ? extends Promise<T>> func) throws Exception {
        return this.yield((Action<? super RegistrySpec>)Action.noop(), func);
    }

    public <T> ExecResult<T> yield(Action<? super RegistrySpec> var1, Function<? super Execution, ? extends Promise<T>> var2) throws Exception;

    public static <T> ExecResult<T> yieldSingle(Function<? super Execution, ? extends Promise<T>> func) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            ExecResult<T> execResult = harness.yield(func);
            return execResult;
        }
    }

    public static <T> ExecResult<T> yieldSingle(Action<? super RegistrySpec> registry, Function<? super Execution, ? extends Promise<T>> func) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            ExecResult<T> execResult = harness.yield(registry, func);
            return execResult;
        }
    }

    default public void run(Action<? super Execution> action) throws Exception {
        this.run((Action<? super RegistrySpec>)Action.noop(), action);
    }

    public void run(Action<? super RegistrySpec> var1, Action<? super Execution> var2) throws Exception;

    public static void runSingle(Action<? super Execution> action) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            harness.run(action);
        }
    }

    public static void runSingle(Action<? super RegistrySpec> registry, Action<? super Execution> action) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            harness.run(registry, action);
        }
    }

    default public void execute(Function<? super Execution, ? extends Operation> function) throws Exception {
        this.yield(e -> ((Operation)function.apply(e)).promise()).getValueOrThrow();
    }

    default public void execute(Action<? super RegistrySpec> registry, Function<? super Execution, ? extends Operation> function) throws Exception {
        this.yield(registry, e -> ((Operation)function.apply(e)).promise()).getValueOrThrow();
    }

    default public void execute(Operation operation) throws Exception {
        this.execute((Function<? super Execution, ? extends Operation>)((Function)e -> operation));
    }

    public static void executeSingle(Function<? super Execution, ? extends Operation> function) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            harness.execute(function);
        }
    }

    public static void executeSingle(Action<? super RegistrySpec> registry, Function<? super Execution, ? extends Operation> function) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            harness.execute(registry, function);
        }
    }

    public static void executeSingle(Operation operation) throws Exception {
        try (ExecHarness harness = ExecHarness.harness();){
            harness.execute(operation);
        }
    }

    @Override
    public void close();
}

