/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.call;

import io.ray.api.options.ActorCreationOptions;
import io.ray.api.options.ActorLifetime;
import io.ray.api.placementgroup.PlacementGroup;
import java.util.Map;

public class BaseActorCreator<T extends BaseActorCreator> {
    protected ActorCreationOptions.Builder builder = new ActorCreationOptions.Builder();

    public T setName(String name) {
        this.builder.setName(name);
        return this.self();
    }

    public T setName(String name, String namespace) {
        this.builder.setName(name);
        this.builder.setNamespace(namespace);
        return this.self();
    }

    public T setLifetime(ActorLifetime lifetime) {
        this.builder.setLifetime(lifetime);
        return this.self();
    }

    public T setResource(String resourceName, Double resourceQuantity) {
        this.builder.setResource(resourceName, resourceQuantity);
        return this.self();
    }

    public T setResources(Map<String, Double> resources) {
        this.builder.setResources(resources);
        return this.self();
    }

    public T setMaxRestarts(int maxRestarts) {
        this.builder.setMaxRestarts(maxRestarts);
        return this.self();
    }

    public T setMaxTaskRetries(int maxTaskRetries) {
        this.builder.setMaxTaskRetries(maxTaskRetries);
        return this.self();
    }

    public T setMaxConcurrency(int maxConcurrency) {
        this.builder.setMaxConcurrency(maxConcurrency);
        return this.self();
    }

    public T setMaxPendingCalls(int maxPendingCalls) {
        this.builder.setMaxPendingCalls(maxPendingCalls);
        return this.self();
    }

    public T setPlacementGroup(PlacementGroup group, int bundleIndex) {
        this.builder.setPlacementGroup(group, bundleIndex);
        return this.self();
    }

    public T setPlacementGroup(PlacementGroup group) {
        return this.setPlacementGroup(group, -1);
    }

    private T self() {
        return (T)this;
    }

    protected ActorCreationOptions buildOptions() {
        return this.builder.build();
    }
}

