/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.ray.api.ActorHandle;
import io.ray.api.BaseActorHandle;
import io.ray.api.CppActorHandle;
import io.ray.api.ObjectRef;
import io.ray.api.PyActorHandle;
import io.ray.api.WaitResult;
import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.exception.RuntimeEnvException;
import io.ray.api.function.CppActorClass;
import io.ray.api.function.CppActorMethod;
import io.ray.api.function.CppFunction;
import io.ray.api.function.PyActorClass;
import io.ray.api.function.PyActorMethod;
import io.ray.api.function.PyFunction;
import io.ray.api.function.RayFunc;
import io.ray.api.function.RayFuncR;
import io.ray.api.id.ActorId;
import io.ray.api.id.ObjectId;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.options.ActorCreationOptions;
import io.ray.api.options.CallOptions;
import io.ray.api.options.PlacementGroupCreationOptions;
import io.ray.api.parallelactor.ParallelActorContext;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtime.RayRuntime;
import io.ray.api.runtimecontext.RuntimeContext;
import io.ray.api.runtimeenv.RuntimeEnv;
import io.ray.runtime.ConcurrencyGroupImpl;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.context.RuntimeContextImpl;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.functionmanager.CppFunctionDescriptor;
import io.ray.runtime.functionmanager.FunctionDescriptor;
import io.ray.runtime.functionmanager.FunctionManager;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.functionmanager.PyFunctionDescriptor;
import io.ray.runtime.functionmanager.RayFunction;
import io.ray.runtime.gcs.GcsClient;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.ObjectRefImpl;
import io.ray.runtime.object.ObjectStore;
import io.ray.runtime.runtimeenv.RuntimeEnvImpl;
import io.ray.runtime.task.ArgumentsBuilder;
import io.ray.runtime.task.FunctionArg;
import io.ray.runtime.task.TaskExecutor;
import io.ray.runtime.task.TaskSubmitter;
import io.ray.runtime.util.ConcurrencyGroupUtils;
import io.ray.runtime.utils.parallelactor.ParallelActorContextImpl;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRayRuntime
implements RayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRayRuntime.class);
    public static final String PYTHON_INIT_METHOD_NAME = "__init__";
    protected RayConfig rayConfig;
    protected TaskExecutor taskExecutor;
    protected FunctionManager functionManager;
    protected RuntimeContext runtimeContext;
    protected ObjectStore objectStore;
    protected TaskSubmitter taskSubmitter;
    protected WorkerContext workerContext;
    private static ParallelActorContextImpl parallelActorContextImpl = new ParallelActorContextImpl();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public AbstractRayRuntime(RayConfig rayConfig) {
        this.rayConfig = rayConfig;
        this.runtimeContext = new RuntimeContextImpl(this);
    }

    public <T> ObjectRef<T> put(T obj) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Putting Object in Task {}.", (Object)this.workerContext.getCurrentTaskId());
        }
        ObjectId objectId = this.objectStore.put(obj);
        return new ObjectRefImpl<Object>(objectId, obj == null ? Object.class : obj.getClass(), true);
    }

    public abstract GcsClient getGcsClient();

    public abstract void start();

    public abstract void run();

    public <T> ObjectRef<T> put(T obj, BaseActorHandle ownerActor) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Putting an object in task {} with {} as the owner.", (Object)this.workerContext.getCurrentTaskId(), (Object)ownerActor.getId());
        }
        ObjectId objectId = this.objectStore.put(obj, ownerActor.getId());
        return new ObjectRefImpl<Object>(objectId, obj == null ? Object.class : obj.getClass(), true);
    }

    public <T> T get(ObjectRef<T> objectRef) throws RuntimeException {
        return this.get(objectRef, -1L);
    }

    public <T> T get(ObjectRef<T> objectRef, long timeoutMs) throws RuntimeException {
        List<T> ret = this.get(ImmutableList.of(objectRef), timeoutMs);
        return ret.get(0);
    }

    public <T> List<T> get(List<ObjectRef<T>> objectRefs) {
        return this.get(objectRefs, -1L);
    }

    public <T> List<T> get(List<ObjectRef<T>> objectRefs, long timeoutMs) {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        Class objectType = null;
        for (ObjectRef<T> o : objectRefs) {
            ObjectRefImpl objectRefImpl = (ObjectRefImpl)o;
            objectIds.add(objectRefImpl.getId());
            objectType = objectRefImpl.getType();
        }
        LOGGER.debug("Getting Objects {}.", objectIds);
        return this.objectStore.get(objectIds, objectType, timeoutMs);
    }

    public void free(List<ObjectRef<?>> objectRefs, boolean localOnly) {
        List<ObjectId> objectIds = objectRefs.stream().map(ref -> ((ObjectRefImpl)ref).getId()).collect(Collectors.toList());
        LOGGER.debug("Freeing Objects {}, localOnly = {}.", objectIds, (Object)localOnly);
        this.objectStore.delete(objectIds, localOnly);
    }

    public <T> WaitResult<T> wait(List<ObjectRef<T>> waitList, int numReturns, int timeoutMs, boolean fetchLocal) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Waiting Objects {} with minimum number {} within {} ms.", new Object[]{waitList, numReturns, timeoutMs});
        }
        return this.objectStore.wait(waitList, numReturns, timeoutMs, fetchLocal);
    }

    public ObjectRef call(RayFunc func, Object[] args, CallOptions options) {
        RayFunction rayFunction = this.functionManager.getFunction(func);
        JavaFunctionDescriptor functionDescriptor = rayFunction.functionDescriptor;
        Optional<Class<?>> returnType = rayFunction.getReturnType();
        return this.callNormalFunction(functionDescriptor, args, returnType, options);
    }

    public ObjectRef call(PyFunction pyFunction, Object[] args, CallOptions options) {
        PyFunctionDescriptor functionDescriptor = new PyFunctionDescriptor(pyFunction.moduleName, "", pyFunction.functionName);
        return this.callNormalFunction(functionDescriptor, args, Optional.of(pyFunction.returnType), options);
    }

    public ObjectRef call(CppFunction cppFunction, Object[] args, CallOptions options) {
        CppFunctionDescriptor functionDescriptor = new CppFunctionDescriptor(cppFunction.functionName, "JAVA", "");
        return this.callNormalFunction(functionDescriptor, args, Optional.of(cppFunction.returnType), options);
    }

    public ObjectRef callActor(ActorHandle<?> actor, RayFunc func, Object[] args, CallOptions options) {
        RayFunction rayFunction = this.functionManager.getFunction(func);
        JavaFunctionDescriptor functionDescriptor = rayFunction.functionDescriptor;
        Optional<Class<?>> returnType = rayFunction.getReturnType();
        return this.callActorFunction((BaseActorHandle)actor, functionDescriptor, args, returnType, options);
    }

    public ObjectRef callActor(PyActorHandle pyActor, PyActorMethod pyActorMethod, Object ... args) {
        PyFunctionDescriptor functionDescriptor = new PyFunctionDescriptor(pyActor.getModuleName(), pyActor.getClassName(), pyActorMethod.methodName);
        return this.callActorFunction((BaseActorHandle)pyActor, functionDescriptor, args, Optional.of(pyActorMethod.returnType), new CallOptions.Builder().build());
    }

    public ObjectRef callActor(CppActorHandle cppActor, CppActorMethod cppActorMethod, Object[] args) {
        CppFunctionDescriptor functionDescriptor = new CppFunctionDescriptor(cppActorMethod.methodName, "JAVA", cppActor.getClassName());
        return this.callActorFunction((BaseActorHandle)cppActor, functionDescriptor, args, Optional.of(cppActorMethod.returnType), new CallOptions.Builder().build());
    }

    public <T> ActorHandle<T> createActor(RayFunc actorFactoryFunc, Object[] args, ActorCreationOptions options) {
        JavaFunctionDescriptor functionDescriptor = this.functionManager.getFunction((RayFunc)actorFactoryFunc).functionDescriptor;
        return (ActorHandle)this.createActorImpl(functionDescriptor, args, options);
    }

    public PyActorHandle createActor(PyActorClass pyActorClass, Object[] args, ActorCreationOptions options) {
        PyFunctionDescriptor functionDescriptor = new PyFunctionDescriptor(pyActorClass.moduleName, pyActorClass.className, PYTHON_INIT_METHOD_NAME);
        return (PyActorHandle)this.createActorImpl(functionDescriptor, args, options);
    }

    public CppActorHandle createActor(CppActorClass cppActorClass, Object[] args, ActorCreationOptions options) {
        CppFunctionDescriptor functionDescriptor = new CppFunctionDescriptor(cppActorClass.createFunctionName, "JAVA", cppActorClass.className);
        return (CppActorHandle)this.createActorImpl(functionDescriptor, args, options);
    }

    public PlacementGroup createPlacementGroup(PlacementGroupCreationOptions creationOptions) {
        Preconditions.checkNotNull(creationOptions, "`PlacementGroupCreationOptions` must be specified when creating a new placement group.");
        return this.taskSubmitter.createPlacementGroup(creationOptions);
    }

    public void removePlacementGroup(PlacementGroupId id) {
        this.taskSubmitter.removePlacementGroup(id);
    }

    public PlacementGroup getPlacementGroup(PlacementGroupId id) {
        return this.getGcsClient().getPlacementGroupInfo(id);
    }

    public PlacementGroup getPlacementGroup(String name, String namespace) {
        return namespace == null ? this.getGcsClient().getPlacementGroupInfo(name, this.runtimeContext.getNamespace()) : this.getGcsClient().getPlacementGroupInfo(name, namespace);
    }

    public List<PlacementGroup> getAllPlacementGroups() {
        return this.getGcsClient().getAllPlacementGroupInfo();
    }

    public boolean waitPlacementGroupReady(PlacementGroupId id, int timeoutSeconds) {
        return this.taskSubmitter.waitPlacementGroupReady(id, timeoutSeconds);
    }

    public <T extends BaseActorHandle> T getActorHandle(ActorId actorId) {
        return (T)this.taskSubmitter.getActor(actorId);
    }

    public ConcurrencyGroup createConcurrencyGroup(String name, int maxConcurrency, List<RayFunc> funcs) {
        return new ConcurrencyGroupImpl(name, maxConcurrency, funcs);
    }

    public List<ConcurrencyGroup> extractConcurrencyGroups(RayFuncR<?> actorConstructorLambda) {
        return ConcurrencyGroupUtils.extractConcurrencyGroupsByAnnotations(actorConstructorLambda);
    }

    public ParallelActorContext getParallelActorContext() {
        return parallelActorContextImpl;
    }

    public RuntimeEnv createRuntimeEnv() {
        return new RuntimeEnvImpl();
    }

    public RuntimeEnv deserializeRuntimeEnv(String serializedRuntimeEnv) throws RuntimeEnvException {
        RuntimeEnvImpl runtimeEnv = new RuntimeEnvImpl();
        try {
            runtimeEnv.runtimeEnvs = (ObjectNode)MAPPER.readTree(serializedRuntimeEnv);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return runtimeEnv;
    }

    private ObjectRef callNormalFunction(FunctionDescriptor functionDescriptor, Object[] args, Optional<Class<?>> returnType, CallOptions options) {
        List<ObjectId> returnIds;
        int numReturns = returnType.isPresent() ? 1 : 0;
        List<FunctionArg> functionArgs = ArgumentsBuilder.wrap(args, functionDescriptor.getLanguage());
        if (options == null) {
            options = new CallOptions.Builder().build();
        }
        ObjectRefImpl impl = new ObjectRefImpl();
        List<ObjectId> preparedReturnIds = this.getCurrentReturnIds(numReturns, ActorId.NIL);
        if (this.rayConfig.runMode == RunMode.CLUSTER && numReturns > 0) {
            ObjectRefImpl.registerObjectRefImpl(preparedReturnIds.get(0), impl);
        }
        Preconditions.checkState((returnIds = this.taskSubmitter.submitTask(functionDescriptor, functionArgs, numReturns, options)).size() == numReturns);
        this.validatePreparedReturnIds(preparedReturnIds, returnIds);
        if (returnIds.isEmpty()) {
            return null;
        }
        impl.init(returnIds.get(0), returnType.get(), true);
        return impl;
    }

    private ObjectRef callActorFunction(BaseActorHandle rayActor, FunctionDescriptor functionDescriptor, Object[] args, Optional<Class<?>> returnType, CallOptions options) {
        List<ObjectId> returnIds;
        int numReturns;
        int n = numReturns = returnType.isPresent() ? 1 : 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Submitting Actor Task {}.", (Object)functionDescriptor);
        }
        List<FunctionArg> functionArgs = ArgumentsBuilder.wrap(args, functionDescriptor.getLanguage());
        ObjectRefImpl impl = new ObjectRefImpl();
        List<ObjectId> preparedReturnIds = this.getCurrentReturnIds(numReturns, rayActor.getId());
        if (this.rayConfig.runMode == RunMode.CLUSTER && numReturns > 0) {
            ObjectRefImpl.registerObjectRefImpl(preparedReturnIds.get(0), impl);
        }
        Preconditions.checkState((returnIds = this.taskSubmitter.submitActorTask(rayActor, functionDescriptor, functionArgs, numReturns, options)).size() == numReturns);
        if (returnIds.isEmpty()) {
            return null;
        }
        this.validatePreparedReturnIds(preparedReturnIds, returnIds);
        impl.init(returnIds.get(0), returnType.get(), true);
        return impl;
    }

    private BaseActorHandle createActorImpl(FunctionDescriptor functionDescriptor, Object[] args, ActorCreationOptions options) {
        if (LOGGER.isDebugEnabled()) {
            if (options == null) {
                LOGGER.debug("Creating Actor {} with default options.", (Object)functionDescriptor);
            } else {
                LOGGER.debug("Creating Actor {}, jvmOptions = {}.", (Object)functionDescriptor, (Object)options.jvmOptions);
            }
        }
        if (this.rayConfig.runMode == RunMode.LOCAL && functionDescriptor.getLanguage() != Common.Language.JAVA) {
            throw new IllegalArgumentException("Ray doesn't support cross-language invocation in local mode.");
        }
        List<FunctionArg> functionArgs = ArgumentsBuilder.wrap(args, functionDescriptor.getLanguage());
        if (functionDescriptor.getLanguage() != Common.Language.JAVA && options != null) {
            Preconditions.checkState(options.jvmOptions == null || options.jvmOptions.size() == 0);
        }
        BaseActorHandle actor = this.taskSubmitter.createActor(functionDescriptor, functionArgs, options);
        return actor;
    }

    abstract List<ObjectId> getCurrentReturnIds(int var1, ActorId var2);

    public WorkerContext getWorkerContext() {
        return this.workerContext;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public RayConfig getRayConfig() {
        return this.rayConfig;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    void validatePreparedReturnIds(List<ObjectId> preparedReturnIds, List<ObjectId> realReturnIds) {
        if (this.rayConfig.runMode == RunMode.CLUSTER) {
            Preconditions.checkState(realReturnIds.size() == preparedReturnIds.size());
            for (int i = 0; i < preparedReturnIds.size(); ++i) {
                ObjectId prepared = preparedReturnIds.get(i);
                ObjectId real = realReturnIds.get(i);
                Preconditions.checkState(prepared.equals((Object)real), "The prepared object id {} is not equal to the real return id {}", (Object)prepared, (Object)real);
            }
        }
    }
}

