/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.BaseActorHandle;
import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.ObjectId;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.id.UniqueId;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtimecontext.ResourceValue;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.context.LocalModeWorkerContext;
import io.ray.runtime.functionmanager.FunctionManager;
import io.ray.runtime.gcs.GcsClient;
import io.ray.runtime.object.LocalModeObjectStore;
import io.ray.runtime.task.LocalModeTaskExecutor;
import io.ray.runtime.task.LocalModeTaskSubmitter;
import io.ray.runtime.util.JniUtils;
import io.ray.runtime.util.SystemUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class RayDevRuntime
extends AbstractRayRuntime {
    private AtomicInteger jobCounter = new AtomicInteger(0);

    public RayDevRuntime(RayConfig rayConfig) {
        super(rayConfig);
    }

    @Override
    public void start() {
        if (this.rayConfig.getJobId().isNil()) {
            this.rayConfig.setJobId(this.nextJobId());
        }
        RayDevRuntime.updateSessionDir(this.rayConfig);
        JniUtils.loadLibrary(this.rayConfig.sessionDir, "core_worker_library_java", true);
        this.taskExecutor = new LocalModeTaskExecutor(this);
        this.workerContext = new LocalModeWorkerContext(this.rayConfig.getJobId());
        this.objectStore = new LocalModeObjectStore(this.workerContext);
        this.functionManager = new FunctionManager(this.rayConfig.codeSearchPath);
        this.taskSubmitter = new LocalModeTaskSubmitter(this, this.taskExecutor, (LocalModeObjectStore)this.objectStore);
        ((LocalModeObjectStore)this.objectStore).addObjectPutCallback(objectId -> {
            if (this.taskSubmitter != null) {
                ((LocalModeTaskSubmitter)this.taskSubmitter).onObjectPut((ObjectId)objectId);
            }
        });
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        if (this.taskSubmitter != null) {
            ((LocalModeTaskSubmitter)this.taskSubmitter).shutdown();
            this.taskSubmitter = null;
        }
        this.taskExecutor = null;
    }

    public void killActor(BaseActorHandle actor, boolean noRestart) {
        throw new UnsupportedOperationException();
    }

    public <T extends BaseActorHandle> Optional<T> getActor(String name, String namespace) {
        return ((LocalModeTaskSubmitter)this.taskSubmitter).getActor(name);
    }

    @Override
    public GcsClient getGcsClient() {
        throw new UnsupportedOperationException("Ray doesn't have gcs client in local mode.");
    }

    public Map<String, List<ResourceValue>> getAvailableResourceIds() {
        throw new UnsupportedOperationException("Ray doesn't support get resources ids in local mode.");
    }

    @Override
    List<ObjectId> getCurrentReturnIds(int numReturns, ActorId actorId) {
        return null;
    }

    @Override
    public PlacementGroup getPlacementGroup(PlacementGroupId id) {
        throw new UnsupportedOperationException("Ray doesn't support placement group operations in local mode.");
    }

    @Override
    public List<PlacementGroup> getAllPlacementGroups() {
        throw new UnsupportedOperationException("Ray doesn't support placement group operations in local mode.");
    }

    public String getNamespace() {
        return null;
    }

    public UniqueId getCurrentNodeId() {
        throw new UnsupportedOperationException("Ray doesn't support it in local mode.");
    }

    public void exitActor() {
    }

    private JobId nextJobId() {
        return JobId.fromInt((int)this.jobCounter.getAndIncrement());
    }

    private static void updateSessionDir(RayConfig rayConfig) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-ms");
        Date date = new Date();
        String sessionDir = String.format("/tmp/ray/session_local_mode_%s_%d", format.format(date), SystemUtil.pid());
        rayConfig.setSessionDir(sessionDir);
    }
}

