/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.actor;

import io.ray.api.BaseActorHandle;
import io.ray.api.Ray;
import io.ray.api.id.ActorId;
import io.ray.api.id.ObjectId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.actor.NativeCppActorHandle;
import io.ray.runtime.actor.NativeJavaActorHandle;
import io.ray.runtime.actor.NativePyActorHandle;
import io.ray.runtime.generated.Common;
import io.ray.shaded.com.google.common.base.FinalizableReferenceQueue;
import io.ray.shaded.com.google.common.base.FinalizableWeakReference;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.Sets;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeActorHandle
implements BaseActorHandle,
Externalizable {
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private static final Set<Reference<NativeActorHandle>> REFERENCES = Sets.newConcurrentHashSet();
    byte[] actorId;
    byte[] actorHandleId = new byte[28];
    private Common.Language language;

    NativeActorHandle(byte[] actorId, Common.Language language) {
        Preconditions.checkState(!ActorId.fromBytes((byte[])actorId).isNil());
        this.actorId = actorId;
        this.language = language;
        new NativeActorHandleReference(this);
    }

    NativeActorHandle() {
    }

    public ObjectId getActorHandleId() {
        return new ObjectId(this.actorHandleId);
    }

    public static NativeActorHandle create(byte[] actorId) {
        Common.Language language = Common.Language.forNumber(NativeActorHandle.nativeGetLanguage(actorId));
        Preconditions.checkState(language != null, "Language shouldn't be null");
        return NativeActorHandle.create(actorId, language);
    }

    public static NativeActorHandle create(byte[] actorId, Common.Language language) {
        switch (language) {
            case JAVA: {
                return new NativeJavaActorHandle(actorId);
            }
            case PYTHON: {
                return new NativePyActorHandle(actorId);
            }
            case CPP: {
                return new NativeCppActorHandle(actorId);
            }
        }
        throw new IllegalStateException("Unknown actor handle language: " + language);
    }

    public ActorId getId() {
        return ActorId.fromBytes((byte[])this.actorId);
    }

    public Common.Language getLanguage() {
        return this.language;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(NativeActorHandle.nativeSerialize(this.actorId, this.actorHandleId));
        out.writeObject(this.language);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.actorId = NativeActorHandle.nativeDeserialize((byte[])in.readObject());
        this.language = (Common.Language)in.readObject();
        new NativeActorHandleReference(this);
    }

    public byte[] toBytes() {
        return NativeActorHandle.nativeSerialize(this.actorId, this.actorHandleId);
    }

    public static NativeActorHandle fromBytes(byte[] bytes) {
        byte[] actorId = NativeActorHandle.nativeDeserialize(bytes);
        Common.Language language = Common.Language.forNumber(NativeActorHandle.nativeGetLanguage(actorId));
        Preconditions.checkNotNull(language);
        return NativeActorHandle.create(actorId, language);
    }

    private static native int nativeGetLanguage(byte[] var0);

    static native List<String> nativeGetActorCreationTaskFunctionDescriptor(byte[] var0);

    private static native byte[] nativeSerialize(byte[] var0, byte[] var1);

    private static native byte[] nativeDeserialize(byte[] var0);

    private static native void nativeRemoveActorHandleReference(byte[] var0);

    private static final class NativeActorHandleReference
    extends FinalizableWeakReference<NativeActorHandle> {
        private final AtomicBoolean removed;
        private final byte[] actorId;

        public NativeActorHandleReference(NativeActorHandle handle) {
            super(handle, REFERENCE_QUEUE);
            this.actorId = handle.actorId;
            AbstractRayRuntime runtime = (AbstractRayRuntime)Ray.internal();
            this.removed = new AtomicBoolean(false);
            REFERENCES.add(this);
        }

        @Override
        public void finalizeReferent() {
            if (!this.removed.getAndSet(true)) {
                REFERENCES.remove(this);
                if (Ray.isInitialized()) {
                    NativeActorHandle.nativeRemoveActorHandleReference(this.actorId);
                }
            }
        }
    }
}

