/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.serializer;

import io.ray.runtime.actor.NativeActorHandle;
import io.ray.runtime.actor.NativeActorHandleSerializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;

public class FstSerializer {
    private static final ThreadLocal<FSTConfiguration> conf = ThreadLocal.withInitial(() -> {
        FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
        conf.registerSerializer(NativeActorHandle.class, (FSTObjectSerializer)new NativeActorHandleSerializer(), true);
        return conf;
    });

    public static byte[] encode(Object obj) {
        FSTConfiguration current = conf.get();
        current.setClassLoader(Thread.currentThread().getContextClassLoader());
        return current.asByteArray(obj);
    }

    public static <T> T decode(byte[] bs) {
        FSTConfiguration current = conf.get();
        current.setClassLoader(Thread.currentThread().getContextClassLoader());
        return (T)current.asObject(bs);
    }
}

