/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util.generator;

import io.ray.runtime.util.generator.BaseGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ConcurrencyGroupBuilderGenerator
extends BaseGenerator {
    private void buildConcurrencyGroupMethods(int numParameters, boolean hasReturn) {
        StringBuilder genericTypes = new StringBuilder();
        for (int i = 0; i < numParameters; ++i) {
            genericTypes.append("T").append(i).append(", ");
        }
        if (hasReturn) {
            genericTypes.append("R, ");
        }
        if (genericTypes.length() > 0) {
            genericTypes = new StringBuilder(genericTypes.substring(0, genericTypes.length() - 2));
            genericTypes = new StringBuilder("<" + genericTypes + ">");
        }
        String returnType = hasReturn ? "ConcurrencyGroupBuilder<A>" : "ConcurrencyGroupBuilder<A>";
        String rayFuncGenericTypes = genericTypes.toString();
        rayFuncGenericTypes = rayFuncGenericTypes.isEmpty() ? "<A>" : rayFuncGenericTypes.replace("<", "<A, ");
        String argsDeclarationPrefix = String.format("RayFunc%s%d%s f, ", hasReturn ? "" : "Void", numParameters + 1, rayFuncGenericTypes);
        for (String param : this.generateParameters(numParameters)) {
            String argsDeclaration = argsDeclarationPrefix + param;
            argsDeclaration = argsDeclaration.substring(0, argsDeclaration.length() - 2);
            String modifiers = "public";
            String callFunc = "addMethod";
            this.newLine(1, String.format("%s%s %s %s(%s) {", "public", genericTypes.length() == 0 ? "" : " " + genericTypes, returnType, "addMethod", argsDeclaration));
            this.newLine(2, "return internalAddMethod(f);");
            this.newLine(1, "}");
            this.newLine("");
        }
    }

    private String generateActorCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `BaseConcurrencyGroupBuilderGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api.concurrencygroup;");
        this.newLine("");
        this.newLine("import io.ray.api.function.RayFunc;");
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for concurrency groups.");
        this.newLine(" **/");
        this.newLine("public abstract class BaseConcurrencyGroupBuilder<A> {");
        this.newLine("");
        this.newLine("  protected abstract ConcurrencyGroupBuilder<A> internalAddMethod(RayFunc func);");
        this.newLine("");
        for (i = 0; i <= 5; ++i) {
            this.buildConcurrencyGroupMethods(i, true);
            this.buildConcurrencyGroupMethods(i, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private List<String> generateParameters(int numParams) {
        ArrayList<String> res = new ArrayList<String>();
        this.dfs(0, numParams, "", res);
        return res;
    }

    private void dfs(int pos, int numParams, String cur, List<String> res) {
        if (pos >= numParams) {
            res.add(cur);
            return;
        }
        String nextParameter = "";
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
    }

    public static void main(String[] args) throws IOException {
        String path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/concurrencyGroup/BaseConcurrencyGroupBuilder.java";
        FileUtils.write((File)new File(path), (CharSequence)new ConcurrencyGroupBuilderGenerator().generateActorCallDotJava(), (Charset)Charset.defaultCharset());
    }
}

