/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import io.ray.api.id.JobId;
import io.ray.api.options.ActorLifetime;
import io.ray.api.runtimeenv.RuntimeEnvConfig;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.generated.Common;
import io.ray.runtime.runtimeenv.RuntimeEnvImpl;
import io.ray.runtime.util.NetworkUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class RayConfig {
    public static final String DEFAULT_CONFIG_FILE = "ray.default.conf";
    public static final String CUSTOM_CONFIG_FILE = "ray.conf";
    private Config config;
    public final String nodeIp;
    public final Common.WorkerType workerMode;
    public final RunMode runMode;
    private JobId jobId;
    public String sessionDir;
    public String logDir;
    private String bootstrapAddress;
    public final String redisPassword;
    public String objectStoreSocketName;
    public String rayletSocketName;
    public int nodeManagerPort;
    public int startupToken;
    public int runtimeEnvHash;
    public RuntimeEnvImpl runtimeEnvImpl = null;
    public final ActorLifetime defaultActorLifetime;
    public final List<LoggerConf> loggers;
    public final List<String> codeSearchPath;
    public final List<String> headArgs;
    public final String namespace;
    public final List<String> jvmOptionsForJavaWorker;

    private void validate() {
        if (this.workerMode == Common.WorkerType.WORKER) {
            Preconditions.checkArgument(this.bootstrapAddress != null, "Bootstrap address must be set in worker mode.");
        }
    }

    private String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public RayConfig(Config config) {
        String bootstrapAddress;
        boolean isDriver;
        Common.WorkerType localWorkerMode;
        this.config = config;
        try {
            localWorkerMode = (Common.WorkerType)config.getEnum(Common.WorkerType.class, "ray.worker.mode");
        }
        catch (ConfigException.Missing e) {
            localWorkerMode = Common.WorkerType.DRIVER;
        }
        this.workerMode = localWorkerMode;
        boolean bl = isDriver = this.workerMode == Common.WorkerType.DRIVER;
        this.runMode = config.hasPath("ray.local-mode") ? (config.getBoolean("ray.local-mode") ? RunMode.LOCAL : RunMode.CLUSTER) : (RunMode)config.getEnum(RunMode.class, "ray.run-mode");
        this.nodeIp = config.hasPath("ray.node-ip") ? config.getString("ray.node-ip") : (SystemUtils.IS_OS_LINUX ? NetworkUtil.getIpAddress(null) : NetworkUtil.localhostIp());
        String jobId = config.getString("ray.job.id");
        this.jobId = !jobId.isEmpty() ? JobId.fromHexString((String)jobId) : JobId.NIL;
        String localNamespace = config.getString("ray.job.namespace");
        this.namespace = this.workerMode == Common.WorkerType.DRIVER ? (StringUtils.isEmpty((CharSequence)localNamespace) ? UUID.randomUUID().toString() : localNamespace) : null;
        this.defaultActorLifetime = (ActorLifetime)config.getEnum(ActorLifetime.class, "ray.job.default-actor-lifetime");
        Preconditions.checkState(this.defaultActorLifetime != null);
        this.jvmOptionsForJavaWorker = config.getStringList("ray.job.jvm-options");
        this.updateSessionDir(null);
        if (config.hasPath("ray.object-store.socket-name")) {
            this.objectStoreSocketName = config.getString("ray.object-store.socket-name");
        }
        if (config.hasPath("ray.raylet.socket-name")) {
            this.rayletSocketName = config.getString("ray.raylet.socket-name");
        }
        if (StringUtils.isNotBlank((CharSequence)(bootstrapAddress = config.getString("ray.address")))) {
            this.setBootstrapAddress(bootstrapAddress);
        } else {
            this.bootstrapAddress = null;
        }
        this.redisPassword = config.getString("ray.redis.password");
        if (config.hasPath("ray.raylet.node-manager-port")) {
            this.nodeManagerPort = config.getInt("ray.raylet.node-manager-port");
        } else {
            Preconditions.checkState(this.workerMode != Common.WorkerType.WORKER, "Worker started by raylet should accept the node manager port from raylet.");
        }
        String codeSearchPathString = null;
        if (config.hasPath("ray.job.code-search-path")) {
            codeSearchPathString = config.getString("ray.job.code-search-path");
        }
        if (StringUtils.isEmpty(codeSearchPathString)) {
            codeSearchPathString = System.getProperty("java.class.path");
        }
        this.codeSearchPath = Arrays.asList(codeSearchPathString.split(":"));
        this.startupToken = config.getInt("ray.raylet.startup-token");
        if (this.workerMode == Common.WorkerType.WORKER && config.hasPath("ray.internal.runtime-env-hash")) {
            this.runtimeEnvHash = config.getInt("ray.internal.runtime-env-hash");
        }
        HashMap envVars = new HashMap();
        List jarUrls = null;
        String envVarsPath = "ray.job.runtime-env.env-vars";
        if (config.hasPath("ray.job.runtime-env.env-vars")) {
            Config envVarsConfig = config.getConfig("ray.job.runtime-env.env-vars");
            envVarsConfig.entrySet().forEach(entry -> envVars.put(entry.getKey(), (String)((ConfigValue)entry.getValue()).unwrapped()));
        }
        String jarsPath = "ray.job.runtime-env.jars";
        if (config.hasPath("ray.job.runtime-env.jars")) {
            jarUrls = config.getStringList("ray.job.runtime-env.jars");
        }
        RuntimeEnvConfig runtimeEnvConfig = null;
        String timeoutPath = "ray.job.runtime-env.config.setup-timeout-seconds";
        if (config.hasPath("ray.job.runtime-env.config.setup-timeout-seconds")) {
            runtimeEnvConfig = new RuntimeEnvConfig();
            runtimeEnvConfig.setSetupTimeoutSeconds(config.getInt("ray.job.runtime-env.config.setup-timeout-seconds"));
        }
        String eagerInstallPath = "ray.job.runtime-env.config.eager-install";
        if (config.hasPath("ray.job.runtime-env.config.eager-install")) {
            if (runtimeEnvConfig == null) {
                runtimeEnvConfig = new RuntimeEnvConfig();
            }
            runtimeEnvConfig.setEagerInstall(config.getBoolean("ray.job.runtime-env.config.eager-install"));
        }
        this.runtimeEnvImpl = new RuntimeEnvImpl();
        if (!envVars.isEmpty()) {
            this.runtimeEnvImpl.set("env_vars", envVars);
        }
        if (!jarUrls.isEmpty()) {
            this.runtimeEnvImpl.set("java_jars", jarUrls);
        }
        if (runtimeEnvConfig != null) {
            this.runtimeEnvImpl.setConfig(runtimeEnvConfig);
        }
        this.loggers = new ArrayList<LoggerConf>();
        List loggerConfigs = config.getConfigList("ray.logging.loggers");
        for (Config loggerConfig : loggerConfigs) {
            Preconditions.checkState(loggerConfig.hasPath("name"));
            Preconditions.checkState(loggerConfig.hasPath("file-name"));
            String name = loggerConfig.getString("name");
            String fileName = loggerConfig.getString("file-name");
            String pattern = loggerConfig.hasPath("pattern") ? loggerConfig.getString("pattern") : "";
            this.loggers.add(new LoggerConf(name, fileName, pattern));
        }
        this.headArgs = config.getStringList("ray.head-args");
        this.validate();
    }

    public void setBootstrapAddress(String bootstrapAddress) {
        Preconditions.checkNotNull(bootstrapAddress);
        Preconditions.checkState(this.bootstrapAddress == null, "Bootstrap address was already set");
        this.bootstrapAddress = bootstrapAddress;
    }

    public String getBootstrapAddress() {
        return this.bootstrapAddress;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public int getNodeManagerPort() {
        return this.nodeManagerPort;
    }

    public int getStartupToken() {
        return this.startupToken;
    }

    public void setSessionDir(String sessionDir) {
        this.updateSessionDir(sessionDir);
    }

    public Config getInternalConfig() {
        return this.config;
    }

    public String toString() {
        HashMap<String, Object> dynamic = new HashMap<String, Object>();
        dynamic.put("ray.session-dir", this.sessionDir);
        dynamic.put("ray.raylet.socket-name", this.rayletSocketName);
        dynamic.put("ray.object-store.socket-name", this.objectStoreSocketName);
        dynamic.put("ray.raylet.node-manager-port", this.nodeManagerPort);
        dynamic.put("ray.address", this.bootstrapAddress);
        dynamic.put("ray.raylet.startup-token", this.startupToken);
        Config toRender = ConfigFactory.parseMap(dynamic).withFallback((ConfigMergeable)this.config);
        return toRender.root().render(ConfigRenderOptions.concise());
    }

    private void updateSessionDir(String sessionDir) {
        if (this.config.hasPath("ray.session-dir")) {
            sessionDir = this.config.getString("ray.session-dir");
        }
        if (sessionDir != null) {
            sessionDir = this.removeTrailingSlash(sessionDir);
        }
        this.sessionDir = sessionDir;
        String localLogDir = null;
        if (this.config.hasPath("ray.logging.dir")) {
            localLogDir = this.removeTrailingSlash(this.config.getString("ray.logging.dir"));
        }
        this.logDir = Strings.isNullOrEmpty(localLogDir) ? String.format("%s/logs", sessionDir) : localLogDir;
    }

    public static RayConfig create() {
        ConfigFactory.invalidateCaches();
        Config config = ConfigFactory.systemProperties();
        String configPath = System.getProperty("ray.config-file");
        config = Strings.isNullOrEmpty(configPath) ? config.withFallback((ConfigMergeable)ConfigFactory.load((String)CUSTOM_CONFIG_FILE)) : config.withFallback((ConfigMergeable)ConfigFactory.parseFile((File)new File(configPath)));
        config = config.withFallback((ConfigMergeable)ConfigFactory.load((String)DEFAULT_CONFIG_FILE));
        return new RayConfig(config.withOnlyPath("ray"));
    }

    public static class LoggerConf {
        public final String loggerName;
        public final String fileName;
        public final String pattern;

        public LoggerConf(String loggerName, String fileName, String pattern) {
            this.loggerName = loggerName;
            this.fileName = fileName;
            this.pattern = pattern;
        }
    }
}

