/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimeenv.RuntimeEnv;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import io.ray.runtime.task.LocalModeTaskSubmitter;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.protobuf.ByteString;
import java.util.Random;

public class LocalModeWorkerContext
implements WorkerContext {
    private final JobId jobId;
    private ThreadLocal<Common.TaskSpec> currentTask = new ThreadLocal();
    private final ThreadLocal<UniqueId> currentWorkerId = new ThreadLocal();

    public LocalModeWorkerContext(JobId jobId) {
        this.jobId = jobId;
        byte[] driverTaskId = new byte[24];
        new Random().nextBytes(driverTaskId);
        Common.TaskSpec dummyDriverTask = Common.TaskSpec.newBuilder().setTaskId(ByteString.copyFrom(driverTaskId)).build();
        this.currentTask.set(dummyDriverTask);
    }

    @Override
    public UniqueId getCurrentWorkerId() {
        return this.currentWorkerId.get();
    }

    public void setCurrentWorkerId(UniqueId workerId) {
        this.currentWorkerId.set(workerId);
    }

    @Override
    public JobId getCurrentJobId() {
        return this.jobId;
    }

    @Override
    public ActorId getCurrentActorId() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        LocalModeWorkerContext.checkTaskSpecNotNull(taskSpec);
        return LocalModeTaskSubmitter.getActorId(taskSpec);
    }

    @Override
    public Common.TaskType getCurrentTaskType() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        LocalModeWorkerContext.checkTaskSpecNotNull(taskSpec);
        return taskSpec.getType();
    }

    @Override
    public TaskId getCurrentTaskId() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        LocalModeWorkerContext.checkTaskSpecNotNull(taskSpec);
        return TaskId.fromBytes((byte[])taskSpec.getTaskId().toByteArray());
    }

    @Override
    public Common.Address getRpcAddress() {
        return Common.Address.getDefaultInstance();
    }

    @Override
    public RuntimeEnv getCurrentRuntimeEnv() {
        throw new RuntimeException("Not implemented.");
    }

    public void setCurrentTask(Common.TaskSpec taskSpec) {
        this.currentTask.set(taskSpec);
    }

    private static void checkTaskSpecNotNull(Common.TaskSpec taskSpec) {
        Preconditions.checkNotNull(taskSpec, "Current task is not set. Maybe you invoked this API in a user-created thread not managed by Ray. Invoking this API in a user-created thread is not supported yet in local mode. You can switch to cluster mode.");
    }
}

