/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import io.ray.api.BaseActorHandle;
import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimecontext.ActorInfo;
import io.ray.api.runtimecontext.ActorState;
import io.ray.api.runtimecontext.NodeInfo;
import io.ray.api.runtimecontext.RuntimeContext;
import io.ray.api.runtimeenv.RuntimeEnv;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.util.ResourceUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RuntimeContextImpl
implements RuntimeContext {
    private AbstractRayRuntime runtime;

    public RuntimeContextImpl(AbstractRayRuntime runtime) {
        this.runtime = runtime;
    }

    public JobId getCurrentJobId() {
        return this.runtime.getWorkerContext().getCurrentJobId();
    }

    public ActorId getCurrentActorId() {
        ActorId actorId = this.runtime.getWorkerContext().getCurrentActorId();
        Preconditions.checkState(actorId != null && !actorId.isNil(), "This method should only be called from an actor.");
        return actorId;
    }

    public TaskId getCurrentTaskId() {
        return this.runtime.getWorkerContext().getCurrentTaskId();
    }

    public boolean wasCurrentActorRestarted() {
        if (this.isLocalMode()) {
            return false;
        }
        return this.runtime.getGcsClient().wasCurrentActorRestarted(this.getCurrentActorId());
    }

    public boolean isLocalMode() {
        return RunMode.LOCAL == this.runtime.getRayConfig().runMode;
    }

    public List<NodeInfo> getAllNodeInfo() {
        return this.runtime.getGcsClient().getAllNodeInfo();
    }

    public List<ActorInfo> getAllActorInfo() {
        return this.runtime.getGcsClient().getAllActorInfo(null, null);
    }

    public List<ActorInfo> getAllActorInfo(JobId jobId, ActorState actorState) {
        return this.runtime.getGcsClient().getAllActorInfo(jobId, actorState);
    }

    public <T extends BaseActorHandle> T getCurrentActorHandle() {
        return this.runtime.getActorHandle(this.getCurrentActorId());
    }

    public List<Long> getGpuIds() {
        ArrayList<Long> gpuIds;
        Map resourceIds = this.runtime.getAvailableResourceIds();
        HashSet assignedIds = new HashSet();
        for (Map.Entry entry : resourceIds.entrySet()) {
            String pattern = "^GPU_group_[0-9A-Za-z]+$";
            if (!((String)entry.getKey()).equals("GPU") && !Pattern.matches(pattern, (CharSequence)entry.getKey())) continue;
            assignedIds.addAll(((List)entry.getValue()).stream().map(x -> x.resourceId).collect(Collectors.toList()));
        }
        List<String> gpuOnThisNode = ResourceUtil.getCudaVisibleDevices();
        if (gpuOnThisNode != null) {
            gpuIds = new ArrayList<Long>();
            for (Long id : assignedIds) {
                gpuIds.add(Long.valueOf(gpuOnThisNode.get(id.intValue())));
            }
        } else {
            gpuIds = new ArrayList(assignedIds);
        }
        return gpuIds;
    }

    public String getNamespace() {
        return this.runtime.getNamespace();
    }

    public UniqueId getCurrentNodeId() {
        return this.runtime.getCurrentNodeId();
    }

    public RuntimeEnv getCurrentRuntimeEnv() {
        return this.runtime.getWorkerContext().getCurrentRuntimeEnv();
    }
}

