/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.serializer;

import io.ray.runtime.serializer.FstSerializer;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public class MessagePackSerializer {
    private static final byte LANGUAGE_SPECIFIC_TYPE_EXTENSION_ID = 101;
    private static final int MESSAGE_PACK_OFFSET = 9;
    private static Map<Class<?>, TypePacker> packers = new HashMap();
    private static Map<ValueType, TypeUnpacker> unpackers = new HashMap<ValueType, TypeUnpacker>();
    private static final TypePacker NULL_PACKER = (object, packer, javaSerializer) -> packer.packNil();
    private static final TypePacker ARRAY_PACKER = (object, packer, javaSerializer) -> {
        int length = Array.getLength(object);
        packer.packArrayHeader(length);
        for (int i = 0; i < length; ++i) {
            MessagePackSerializer.pack(Array.get(object, i), packer, javaSerializer);
        }
    };
    private static final TypePacker EXTENSION_PACKER = (object, packer, javaSerializer) -> javaSerializer.serialize(object, packer);

    private static boolean checkTypeCompatible(List<Class<?>> expected, Class<?> actual) {
        for (Class<?> expectedClass : expected) {
            if (!actual.isAssignableFrom(expectedClass)) continue;
            return true;
        }
        return false;
    }

    private static void pack(Object object, MessagePacker packer, JavaSerializer javaSerializer) throws IOException {
        TypePacker typePacker;
        if (object == null) {
            typePacker = NULL_PACKER;
        } else {
            Class<?> type = object.getClass();
            typePacker = packers.get(type);
            if (typePacker == null) {
                typePacker = type.isArray() ? ARRAY_PACKER : EXTENSION_PACKER;
            }
        }
        try {
            typePacker.pack(object, packer, javaSerializer);
        }
        catch (Exception e) {
            if (typePacker != EXTENSION_PACKER) {
                EXTENSION_PACKER.pack(object, packer, javaSerializer);
            }
            throw e;
        }
    }

    private static Object unpack(Value v, Class<?> type, JavaDeserializer javaDeserializer) {
        return unpackers.get(v.getValueType()).unpack(v, type, javaDeserializer);
    }

    public static Pair<byte[], Boolean> encode(Object obj) {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        try {
            packer.writePayload(new byte[9]);
            MutableBoolean isCrossLanguage = new MutableBoolean(true);
            MessagePackSerializer.pack(obj, (MessagePacker)packer, (object, packer1) -> {
                byte[] payload = FstSerializer.encode(object);
                packer1.packExtensionTypeHeader((byte)101, payload.length);
                packer1.addPayload(payload);
                isCrossLanguage.setFalse();
            });
            byte[] msgpackBytes = packer.toByteArray();
            MessageBufferPacker headerPacker = MessagePack.newDefaultBufferPacker();
            Preconditions.checkState(msgpackBytes.length >= 9);
            headerPacker.packLong((long)(msgpackBytes.length - 9));
            byte[] msgpackBytesLength = headerPacker.toByteArray();
            Preconditions.checkState(msgpackBytesLength.length <= 9);
            System.arraycopy(msgpackBytesLength, 0, msgpackBytes, 0, msgpackBytesLength.length);
            return ImmutablePair.of((Object)msgpackBytes, (Object)isCrossLanguage.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T decode(byte[] bs, Class<?> type) {
        try {
            MessageUnpacker headerUnpacker = MessagePack.newDefaultUnpacker((byte[])bs, (int)0, (int)9);
            long msgpackBytesLength = headerUnpacker.unpackLong();
            headerUnpacker.close();
            Preconditions.checkState(9L + msgpackBytesLength <= (long)bs.length);
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bs, (int)9, (int)((int)msgpackBytesLength));
            ImmutableValue v = unpacker.unpackValue();
            if (type == null) {
                type = Object.class;
            }
            return (T)MessagePackSerializer.unpack((Value)v, type, ev -> FstSerializer.decode(ev.getData()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        packers.put(Boolean.class, (object, packer, javaSerializer) -> packer.packBoolean(((Boolean)object).booleanValue()));
        packers.put(Byte.class, (object, packer, javaSerializer) -> packer.packByte(((Byte)object).byteValue()));
        packers.put(Short.class, (object, packer, javaSerializer) -> packer.packShort(((Short)object).shortValue()));
        packers.put(Integer.class, (object, packer, javaSerializer) -> packer.packInt(((Integer)object).intValue()));
        packers.put(Long.class, (object, packer, javaSerializer) -> packer.packLong(((Long)object).longValue()));
        packers.put(BigInteger.class, (object, packer, javaSerializer) -> packer.packBigInteger((BigInteger)object));
        packers.put(Float.class, (object, packer, javaSerializer) -> packer.packFloat(((Float)object).floatValue()));
        packers.put(Double.class, (object, packer, javaSerializer) -> packer.packDouble(((Double)object).doubleValue()));
        packers.put(String.class, (object, packer, javaSerializer) -> packer.packString((String)object));
        packers.put(byte[].class, (object, packer, javaSerializer) -> {
            byte[] bytes = (byte[])object;
            packer.packBinaryHeader(bytes.length);
            packer.writePayload(bytes);
        });
        ImmutableList<Class<Boolean>> booleanClasses = ImmutableList.of(Boolean.class, Boolean.TYPE);
        ImmutableList<Class<Byte>> byteClasses = ImmutableList.of(Byte.class, Byte.TYPE);
        ImmutableList<Class<Short>> shortClasses = ImmutableList.of(Short.class, Short.TYPE);
        ImmutableList<Class<Integer>> intClasses = ImmutableList.of(Integer.class, Integer.TYPE);
        ImmutableList<Class<Long>> longClasses = ImmutableList.of(Long.class, Long.TYPE);
        ImmutableList<Class<BigInteger>> bigIntClasses = ImmutableList.of(BigInteger.class);
        ImmutableList<Class<Float>> floatClasses = ImmutableList.of(Float.class, Float.TYPE);
        ImmutableList<Class<Double>> doubleClasses = ImmutableList.of(Double.class, Double.TYPE);
        ImmutableList<Class<String>> stringClasses = ImmutableList.of(String.class);
        ImmutableList<Class<byte[]>> binaryClasses = ImmutableList.of(byte[].class);
        unpackers.put(ValueType.NIL, (value, targetClass, javaDeserializer) -> null);
        unpackers.put(ValueType.BOOLEAN, (value, targetClass, javaDeserializer) -> {
            Preconditions.checkArgument(MessagePackSerializer.checkTypeCompatible(booleanClasses, targetClass), "Boolean can't be deserialized as {}.", (Object)targetClass);
            return value.asBooleanValue().getBoolean();
        });
        unpackers.put(ValueType.INTEGER, (value, targetClass, javaDeserializer) -> {
            IntegerValue iv = value.asIntegerValue();
            if (iv.isInByteRange() && MessagePackSerializer.checkTypeCompatible(byteClasses, targetClass)) {
                return iv.asByte();
            }
            if (iv.isInShortRange() && MessagePackSerializer.checkTypeCompatible(shortClasses, targetClass)) {
                return iv.asShort();
            }
            if (iv.isInIntRange() && MessagePackSerializer.checkTypeCompatible(intClasses, targetClass)) {
                return iv.asInt();
            }
            if (iv.isInLongRange() && MessagePackSerializer.checkTypeCompatible(longClasses, targetClass)) {
                return iv.asLong();
            }
            if (MessagePackSerializer.checkTypeCompatible(bigIntClasses, targetClass)) {
                return iv.asBigInteger();
            }
            throw new IllegalArgumentException("Integer can't be deserialized as " + targetClass + ".");
        });
        unpackers.put(ValueType.FLOAT, (value, targetClass, javaDeserializer) -> {
            if (MessagePackSerializer.checkTypeCompatible(doubleClasses, targetClass)) {
                return value.asFloatValue().toDouble();
            }
            if (MessagePackSerializer.checkTypeCompatible(floatClasses, targetClass)) {
                return Float.valueOf(value.asFloatValue().toFloat());
            }
            throw new IllegalArgumentException("Float can't be deserialized as " + targetClass + ".");
        });
        unpackers.put(ValueType.STRING, (value, targetClass, javaDeserializer) -> {
            Preconditions.checkArgument(MessagePackSerializer.checkTypeCompatible(stringClasses, targetClass), "String can't be deserialized as {}.", (Object)targetClass);
            return value.asStringValue().asString();
        });
        unpackers.put(ValueType.BINARY, (value, targetClass, javaDeserializer) -> {
            Preconditions.checkArgument(MessagePackSerializer.checkTypeCompatible(binaryClasses, targetClass), "Binary can't be deserialized as {}.", (Object)targetClass);
            return value.asBinaryValue().asByteArray();
        });
        unpackers.put(ValueType.ARRAY, (value, targetClass, javaDeserializer) -> {
            ArrayValue av = value.asArrayValue();
            Class componentType = targetClass.isArray() ? targetClass.getComponentType() : Object.class;
            Object array = Array.newInstance(componentType, av.size());
            for (int i = 0; i < av.size(); ++i) {
                Array.set(array, i, MessagePackSerializer.unpack(av.get(i), componentType, javaDeserializer));
            }
            return array;
        });
        unpackers.put(ValueType.EXTENSION, (value, targetClass, javaDeserializer) -> {
            ExtensionValue ev = value.asExtensionValue();
            byte extType = ev.getType();
            if (extType == 101) {
                return javaDeserializer.deserialize(ev);
            }
            throw new IllegalArgumentException("Unknown extension type id " + ev.getType() + ".");
        });
    }

    static interface TypeUnpacker {
        public Object unpack(Value var1, Class<?> var2, JavaDeserializer var3);
    }

    static interface TypePacker {
        public void pack(Object var1, MessagePacker var2, JavaSerializer var3) throws IOException;
    }

    static interface JavaDeserializer {
        public Object deserialize(ExtensionValue var1);
    }

    static interface JavaSerializer {
        public void serialize(Object var1, MessagePacker var2) throws IOException;
    }
}

