/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util.generator;

import io.ray.runtime.util.generator.BaseGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ParallelActorCallGenerator
extends BaseGenerator {
    private String generateRayCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `ParallelActorCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api.parallelactor;");
        this.newLine("");
        this.newLine("import io.ray.api.ObjectRef;");
        for (i = 0; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFunc" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for `ParallelActor.actor`.");
        this.newLine(" **/");
        this.newLine("class Call {");
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Methods for actor creation.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, true, true);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generateActorCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api.parallelactor;");
        this.newLine("");
        this.newLine("import io.ray.api.ObjectRef;");
        this.newLine("import io.ray.api.function.RayFuncVoid;");
        this.newLine("import io.ray.api.function.RayFuncR;");
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("interface ActorCall<A> {");
        this.newLine("");
        this.newLine(0, "  default VoidParallelActorTaskCaller buildVoidReturnCaller(RayFuncVoid func, Object[] args) {\n    return new VoidParallelActorTaskCaller((ParallelActorInstance) this, func, args);\n }\n");
        this.newLine(0, "  default <R> ParallelActorTaskCaller<R> buildCaller(RayFuncR<R> func, Object[] args) {\n    return new ParallelActorTaskCaller<R>((ParallelActorInstance) this, func, args);\n  }\n");
        for (i = 0; i <= 5; ++i) {
            this.buildCalls(i, true, false, true);
            this.buildCalls(i, true, false, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private void buildCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasReturn) {
        String callFunc;
        String modifiers = forActor ? "default" : "public static";
        String genericTypes = "";
        for (int i = 0; i < numParameters; ++i) {
            genericTypes = genericTypes + "T" + i + ", ";
        }
        if (forActorCreation) {
            genericTypes = genericTypes + "A, ";
        } else if (hasReturn) {
            genericTypes = genericTypes + "R, ";
        }
        if (!genericTypes.isEmpty()) {
            genericTypes = genericTypes.substring(0, genericTypes.length() - 2);
            genericTypes = "<" + genericTypes + ">";
        }
        String returnType = forActorCreation ? "ParallelActorCreator<A>" : (forActor ? (hasReturn ? "ParallelActorTaskCaller<R>" : "VoidParallelActorTaskCaller") : (hasReturn ? "TaskCaller<R>" : "VoidTaskCaller"));
        String rayFuncGenericTypes = genericTypes;
        if (forActor) {
            rayFuncGenericTypes = rayFuncGenericTypes.isEmpty() ? "<A>" : rayFuncGenericTypes.replace("<", "<A, ");
        }
        String argsDeclarationPrefix = String.format("RayFunc%s%d%s f, ", hasReturn ? "" : "Void", !forActor ? numParameters : numParameters + 1, rayFuncGenericTypes);
        String string = callFunc = forActorCreation ? "actor" : "task";
        String caller = forActorCreation ? "ParallelActorCreator<>" : (forActor ? (hasReturn ? "buildCaller" : "buildVoidReturnCaller") : (hasReturn ? "buildCaller" : "buildVoidReturnCaller"));
        for (String param : this.generateParameters(numParameters)) {
            String argsDeclaration = argsDeclarationPrefix + param;
            argsDeclaration = argsDeclaration.substring(0, argsDeclaration.length() - 2);
            this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericTypes.isEmpty() ? "" : " " + genericTypes, returnType, callFunc, argsDeclaration));
            String args = "";
            for (int i = 0; i < numParameters; ++i) {
                args = args + "t" + i + ", ";
            }
            if (!args.isEmpty()) {
                args = args.substring(0, args.length() - 2);
            }
            this.newLine(2, String.format("Object[] args = new Object[] {%s};", args));
            String ctrArgs = "";
            ctrArgs = ctrArgs + "f, args, ";
            ctrArgs = ctrArgs.substring(0, ctrArgs.length() - 2);
            if (forActorCreation) {
                this.newLine(2, String.format("return new %s(%s);", caller, ctrArgs));
            } else {
                this.newLine(2, String.format("return %s(%s);", caller, ctrArgs));
            }
            this.newLine(1, "}");
            this.newLine("");
        }
    }

    private void buildPyCalls(int numParameters, boolean forActor, boolean forActorCreation) {
        String funcName;
        String genericType;
        String modifiers = forActor ? "default" : "public static";
        String argList = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            paramList = paramList + "Object obj" + i + ", ";
            argList = argList + "obj" + i + ", ";
        }
        if (argList.endsWith(", ")) {
            argList = argList.substring(0, argList.length() - 2);
        }
        if (paramList.endsWith(", ")) {
            paramList = paramList.substring(0, paramList.length() - 2);
        }
        String paramPrefix = "";
        String funcArgs = "";
        if (forActorCreation) {
            paramPrefix = paramPrefix + "PyActorClass pyActorClass";
            funcArgs = funcArgs + "pyActorClass";
        } else if (forActor) {
            paramPrefix = paramPrefix + "PyActorMethod<R> pyActorMethod";
            funcArgs = funcArgs + "pyActorMethod";
        } else {
            paramPrefix = paramPrefix + "PyFunction<R> pyFunction";
            funcArgs = funcArgs + "pyFunction";
        }
        if (numParameters > 0) {
            paramPrefix = paramPrefix + ", ";
        }
        String string = genericType = forActorCreation ? "" : " <R>";
        String returnType = forActorCreation ? "ParallelActorCreator" : (forActor ? "PyActorTaskCaller<R>" : "PyTaskCaller<R>");
        String string2 = funcName = forActorCreation ? "actor" : "task";
        String caller = forActorCreation ? "ParallelActorCreator" : (forActor ? "PyActorTaskCaller<>" : "PyTaskCaller<>");
        funcArgs = funcArgs + ", args";
        this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericType, returnType, funcName, paramPrefix + paramList));
        this.newLine(2, String.format("Object[] args = new Object[] {%s};", argList));
        if (forActor) {
            this.newLine(2, String.format("return new %s((PyActorHandle)this, %s);", caller, funcArgs));
        } else {
            this.newLine(2, String.format("return new %s(%s);", caller, funcArgs));
        }
        this.newLine(1, "}");
        this.newLine("");
    }

    private List<String> generateParameters(int numParams) {
        ArrayList<String> res = new ArrayList<String>();
        this.dfs(0, numParams, "", res);
        return res;
    }

    private void dfs(int pos, int numParams, String cur, List<String> res) {
        if (pos >= numParams) {
            res.add(cur);
            return;
        }
        String nextParameter = String.format("T%d t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
        nextParameter = String.format("ObjectRef<T%d> t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
    }

    public static void main(String[] args) throws IOException {
        String path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/parallelactor/Call.java";
        FileUtils.write((File)new File(path), (CharSequence)new ParallelActorCallGenerator().generateRayCallDotJava(), (Charset)Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/parallelactor/ActorCall.java";
        FileUtils.write((File)new File(path), (CharSequence)new ParallelActorCallGenerator().generateActorCallDotJava(), (Charset)Charset.defaultCharset());
    }
}

