/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util.generator;

import io.ray.runtime.util.generator.BaseGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class RayCallGenerator
extends BaseGenerator {
    private String generateRayCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api;");
        this.newLine("");
        this.newLine("import io.ray.api.call.ActorCreator;");
        this.newLine("import io.ray.api.call.CppActorCreator;");
        this.newLine("import io.ray.api.call.CppTaskCaller;");
        this.newLine("import io.ray.api.call.PyActorCreator;");
        this.newLine("import io.ray.api.call.PyTaskCaller;");
        this.newLine("import io.ray.api.call.TaskCaller;");
        this.newLine("import io.ray.api.call.VoidTaskCaller;");
        this.newLine("import io.ray.api.function.CppActorClass;");
        this.newLine("import io.ray.api.function.CppFunction;");
        this.newLine("import io.ray.api.function.PyActorClass;");
        this.newLine("import io.ray.api.function.PyFunction;");
        for (i = 0; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 0; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for `Ray.call` and `Ray.createActor`.");
        this.newLine(" **/");
        this.newLine("class RayCall {");
        this.newLine(1, "// =======================================");
        this.newLine(1, "// Methods for remote function invocation.");
        this.newLine(1, "// =======================================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, false, true);
            this.buildCalls(i, false, false, false);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Methods for actor creation.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, true, true);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Cross-language methods.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, false);
        }
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, true);
        }
        for (i = 0; i <= 6; ++i) {
            this.buildCppCalls(i, false, false);
        }
        for (i = 0; i <= 6; ++i) {
            this.buildCppCalls(i, false, true);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generateActorCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api;");
        this.newLine("");
        this.newLine("import io.ray.api.call.ActorTaskCaller;");
        this.newLine("import io.ray.api.call.VoidActorTaskCaller;");
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 1; i <= 6; ++i) {
            this.newLine("import io.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("interface ActorCall<A> {");
        this.newLine("");
        for (i = 0; i <= 5; ++i) {
            this.buildCalls(i, true, false, true);
            this.buildCalls(i, true, false, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generatePyActorCallDotJava() {
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api;");
        this.newLine("");
        this.newLine("import io.ray.api.call.PyActorTaskCaller;");
        this.newLine("import io.ray.api.function.PyActorMethod;");
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("interface PyActorCall {");
        this.newLine("");
        for (int i = 0; i <= 5; ++i) {
            this.buildPyCalls(i, true, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generateCppActorCallDotJava() {
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package io.ray.api;");
        this.newLine("");
        this.newLine("import io.ray.api.call.CppActorTaskCaller;");
        this.newLine("import io.ray.api.function.CppActorMethod;");
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("interface CppActorCall {");
        this.newLine("");
        for (int i = 0; i <= 5; ++i) {
            this.buildCppCalls(i, true, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private void buildCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasReturn) {
        String callFunc;
        String modifiers = forActor ? "default" : "public static";
        String genericTypes = "";
        for (int i = 0; i < numParameters; ++i) {
            genericTypes = genericTypes + "T" + i + ", ";
        }
        if (forActorCreation) {
            genericTypes = genericTypes + "A, ";
        } else if (hasReturn) {
            genericTypes = genericTypes + "R, ";
        }
        if (!genericTypes.isEmpty()) {
            genericTypes = genericTypes.substring(0, genericTypes.length() - 2);
            genericTypes = "<" + genericTypes + ">";
        }
        String returnType = forActorCreation ? "ActorCreator<A>" : (forActor ? (hasReturn ? "ActorTaskCaller<R>" : "VoidActorTaskCaller") : (hasReturn ? "TaskCaller<R>" : "VoidTaskCaller"));
        String rayFuncGenericTypes = genericTypes;
        if (forActor) {
            rayFuncGenericTypes = rayFuncGenericTypes.isEmpty() ? "<A>" : rayFuncGenericTypes.replace("<", "<A, ");
        }
        String argsDeclarationPrefix = String.format("RayFunc%s%d%s f, ", hasReturn ? "" : "Void", !forActor ? numParameters : numParameters + 1, rayFuncGenericTypes);
        String string = callFunc = forActorCreation ? "actor" : "task";
        String caller = forActorCreation ? "ActorCreator<>" : (forActor ? (hasReturn ? "ActorTaskCaller<>" : "VoidActorTaskCaller") : (hasReturn ? "TaskCaller<>" : "VoidTaskCaller"));
        for (String param : this.generateParameters(numParameters)) {
            String argsDeclaration = argsDeclarationPrefix + param;
            argsDeclaration = argsDeclaration.substring(0, argsDeclaration.length() - 2);
            this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericTypes.isEmpty() ? "" : " " + genericTypes, returnType, callFunc, argsDeclaration));
            String args = "";
            for (int i = 0; i < numParameters; ++i) {
                args = args + "t" + i + ", ";
            }
            if (!args.isEmpty()) {
                args = args.substring(0, args.length() - 2);
            }
            this.newLine(2, String.format("Object[] args = new Object[]{%s};", args));
            String ctrArgs = "";
            if (forActor) {
                ctrArgs = ctrArgs + "(ActorHandle) this, ";
            }
            ctrArgs = ctrArgs + "f, args, ";
            ctrArgs = ctrArgs.substring(0, ctrArgs.length() - 2);
            this.newLine(2, String.format("return new %s(%s);", caller, ctrArgs));
            this.newLine(1, "}");
            this.newLine("");
        }
    }

    private void buildPyCalls(int numParameters, boolean forActor, boolean forActorCreation) {
        String funcName;
        String genericType;
        String modifiers = forActor ? "default" : "public static";
        String argList = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            paramList = paramList + "Object obj" + i + ", ";
            argList = argList + "obj" + i + ", ";
        }
        if (argList.endsWith(", ")) {
            argList = argList.substring(0, argList.length() - 2);
        }
        if (paramList.endsWith(", ")) {
            paramList = paramList.substring(0, paramList.length() - 2);
        }
        String paramPrefix = "";
        String funcArgs = "";
        if (forActorCreation) {
            paramPrefix = paramPrefix + "PyActorClass pyActorClass";
            funcArgs = funcArgs + "pyActorClass";
        } else if (forActor) {
            paramPrefix = paramPrefix + "PyActorMethod<R> pyActorMethod";
            funcArgs = funcArgs + "pyActorMethod";
        } else {
            paramPrefix = paramPrefix + "PyFunction<R> pyFunction";
            funcArgs = funcArgs + "pyFunction";
        }
        if (numParameters > 0) {
            paramPrefix = paramPrefix + ", ";
        }
        String string = genericType = forActorCreation ? "" : " <R>";
        String returnType = forActorCreation ? "PyActorCreator" : (forActor ? "PyActorTaskCaller<R>" : "PyTaskCaller<R>");
        String string2 = funcName = forActorCreation ? "actor" : "task";
        String caller = forActorCreation ? "PyActorCreator" : (forActor ? "PyActorTaskCaller<>" : "PyTaskCaller<>");
        funcArgs = funcArgs + ", args";
        this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericType, returnType, funcName, paramPrefix + paramList));
        this.newLine(2, String.format("Object[] args = new Object[]{%s};", argList));
        if (forActor) {
            this.newLine(2, String.format("return new %s((PyActorHandle)this, %s);", caller, funcArgs));
        } else {
            this.newLine(2, String.format("return new %s(%s);", caller, funcArgs));
        }
        this.newLine(1, "}");
        this.newLine("");
    }

    private void buildCppCalls(int numParameters, boolean forActor, boolean forActorCreation) {
        String funcName;
        String genericType;
        String modifiers = forActor ? "default" : "public static";
        String argList = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            paramList = paramList + "Object obj" + i + ", ";
            argList = argList + "obj" + i + ", ";
        }
        if (argList.endsWith(", ")) {
            argList = argList.substring(0, argList.length() - 2);
        }
        if (paramList.endsWith(", ")) {
            paramList = paramList.substring(0, paramList.length() - 2);
        }
        String paramPrefix = "";
        String funcArgs = "";
        if (forActorCreation) {
            paramPrefix = paramPrefix + "CppActorClass cppActorClass";
            funcArgs = funcArgs + "cppActorClass";
        } else if (forActor) {
            paramPrefix = paramPrefix + "CppActorMethod<R> cppActorMethod";
            funcArgs = funcArgs + "cppActorMethod";
        } else {
            paramPrefix = paramPrefix + "CppFunction<R> cppFunction";
            funcArgs = funcArgs + "cppFunction";
        }
        if (numParameters > 0) {
            paramPrefix = paramPrefix + ", ";
        }
        String string = genericType = forActorCreation ? "" : " <R>";
        String returnType = forActorCreation ? "CppActorCreator" : (forActor ? "CppActorTaskCaller<R>" : "CppTaskCaller<R>");
        String string2 = funcName = forActorCreation ? "actor" : "task";
        String caller = forActorCreation ? "CppActorCreator" : (forActor ? "CppActorTaskCaller<>" : "CppTaskCaller<>");
        funcArgs = funcArgs + ", args";
        this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericType, returnType, funcName, paramPrefix + paramList));
        this.newLine(2, String.format("Object[] args = new Object[]{%s};", argList));
        if (forActor) {
            this.newLine(2, String.format("return new %s((CppActorHandle)this, %s);", caller, funcArgs));
        } else {
            this.newLine(2, String.format("return new %s(%s);", caller, funcArgs));
        }
        this.newLine(1, "}");
        this.newLine("");
    }

    private List<String> generateParameters(int numParams) {
        ArrayList<String> res = new ArrayList<String>();
        this.dfs(0, numParams, "", res);
        return res;
    }

    private void dfs(int pos, int numParams, String cur, List<String> res) {
        if (pos >= numParams) {
            res.add(cur);
            return;
        }
        String nextParameter = String.format("T%d t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
        nextParameter = String.format("ObjectRef<T%d> t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
    }

    public static void main(String[] args) throws IOException {
        String path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/RayCall.java";
        FileUtils.write((File)new File(path), (CharSequence)new RayCallGenerator().generateRayCallDotJava(), (Charset)Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/ActorCall.java";
        FileUtils.write((File)new File(path), (CharSequence)new RayCallGenerator().generateActorCallDotJava(), (Charset)Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/PyActorCall.java";
        FileUtils.write((File)new File(path), (CharSequence)new RayCallGenerator().generatePyActorCallDotJava(), (Charset)Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/CppActorCall.java";
        FileUtils.write((File)new File(path), (CharSequence)new RayCallGenerator().generateCppActorCallDotJava(), (Charset)Charset.defaultCharset());
    }
}

