/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.utils.parallelactor;

import io.ray.api.Ray;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.functionmanager.FunctionManager;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.functionmanager.RayFunction;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelActorExecutorImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelActorExecutorImpl.class);
    private FunctionManager functionManager = null;
    private ConcurrentHashMap<Integer, Object> instances = new ConcurrentHashMap();

    public ParallelActorExecutorImpl(int parallelism, JavaFunctionDescriptor javaFunctionDescriptor) throws InvocationTargetException, IllegalAccessException {
        this.functionManager = ((AbstractRayRuntime)Ray.internal()).getFunctionManager();
        RayFunction init = this.functionManager.getFunction(javaFunctionDescriptor);
        Thread.currentThread().setContextClassLoader(init.classLoader);
        for (int i = 0; i < parallelism; ++i) {
            Object instance = init.getMethod().invoke(null, new Object[0]);
            this.instances.put(i, instance);
        }
    }

    public Object execute(int instanceId, JavaFunctionDescriptor functionDescriptor, Object[] args) throws IllegalAccessException, InvocationTargetException {
        RayFunction func = this.functionManager.getFunction(functionDescriptor);
        Preconditions.checkState(this.instances.containsKey(instanceId));
        return func.getMethod().invoke(this.instances.get(instanceId), args);
    }
}

