/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.Ray;
import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.function.RayFunc;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.functionmanager.FunctionDescriptor;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.functionmanager.RayFunction;
import java.util.ArrayList;
import java.util.List;

public class ConcurrencyGroupImpl
implements ConcurrencyGroup {
    private String name;
    private int maxConcurrency;
    private List<FunctionDescriptor> functionDescriptors = new ArrayList<FunctionDescriptor>();

    public ConcurrencyGroupImpl(String name, int maxConcurrency, List<RayFunc> funcs) {
        this.name = name;
        this.maxConcurrency = maxConcurrency;
        funcs.forEach(func -> {
            RayFunction rayFunc = ((AbstractRayRuntime)Ray.internal()).getFunctionManager().getFunction((RayFunc)func);
            this.functionDescriptors.add(rayFunc.getFunctionDescriptor());
        });
    }

    public ConcurrencyGroupImpl(String name, int maxConcurrency) {
        this.name = name;
        this.maxConcurrency = maxConcurrency;
    }

    public void addJavaFunctionDescriptor(JavaFunctionDescriptor javaFunctionDescriptor) {
        this.functionDescriptors.add(javaFunctionDescriptor);
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public List<FunctionDescriptor> getFunctionDescriptors() {
        return this.functionDescriptors;
    }

    public String getName() {
        return this.name;
    }
}

