/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.functionmanager;

import io.ray.api.function.RayFunc;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.functionmanager.RayFunction;
import io.ray.runtime.util.LambdaUtils;
import io.ray.shaded.com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionManager.class);
    static final String CONSTRUCTOR_NAME = "<init>";
    private static final ThreadLocal<WeakHashMap<Class<? extends RayFunc>, JavaFunctionDescriptor>> RAY_FUNC_CACHE = ThreadLocal.withInitial(WeakHashMap::new);
    private final JobFunctionTable jobFunctionTable;
    private final List<String> codeSearchPath;

    public FunctionManager(List<String> codeSearchPath) {
        this.codeSearchPath = codeSearchPath;
        this.jobFunctionTable = this.createJobFunctionTable();
    }

    public ClassLoader getClassLoader() {
        return this.jobFunctionTable.classLoader;
    }

    public RayFunction getFunction(RayFunc func) {
        JavaFunctionDescriptor functionDescriptor = RAY_FUNC_CACHE.get().get(func.getClass());
        if (functionDescriptor == null) {
            SerializedLambda serializedLambda = LambdaUtils.getSerializedLambda((Serializable)func);
            String className = serializedLambda.getImplClass().replace('/', '.');
            String methodName = serializedLambda.getImplMethodName();
            String signature = serializedLambda.getImplMethodSignature();
            functionDescriptor = new JavaFunctionDescriptor(className, methodName, signature);
            RAY_FUNC_CACHE.get().put(func.getClass(), functionDescriptor);
        }
        return this.getFunction(functionDescriptor);
    }

    public RayFunction getFunction(JavaFunctionDescriptor functionDescriptor) {
        return this.jobFunctionTable.getFunction(functionDescriptor);
    }

    private JobFunctionTable createJobFunctionTable() {
        ClassLoader classLoader;
        if (this.codeSearchPath == null || this.codeSearchPath.isEmpty()) {
            classLoader = this.getClass().getClassLoader();
        } else {
            URL[] urls = (URL[])this.codeSearchPath.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p) && Files.exists(Paths.get(p, new String[0]), new LinkOption[0])).flatMap(p -> {
                try {
                    if (!Files.isDirectory(Paths.get(p, new String[0]), new LinkOption[0])) {
                        if (!p.endsWith(".jar")) {
                            return Stream.of(Paths.get(p, new String[0]).getParent().toAbsolutePath().toUri().toURL());
                        }
                        return Stream.of(Paths.get(p, new String[0]).toAbsolutePath().toUri().toURL());
                    }
                    ArrayList<URL> subUrls = new ArrayList<URL>();
                    subUrls.add(Paths.get(p, new String[0]).toAbsolutePath().toUri().toURL());
                    Collection jars = FileUtils.listFiles((File)new File((String)p), (IOFileFilter)new RegexFileFilter(".*\\.jar"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                    for (File jar : jars) {
                        subUrls.add(jar.toPath().toUri().toURL());
                    }
                    return subUrls.stream();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(String.format("Illegal %s resource path", p));
                }
            }).toArray(URL[]::new);
            classLoader = new URLClassLoader(urls);
            LOGGER.debug("Resource loaded from path {}.", (Object[])urls);
        }
        return new JobFunctionTable(classLoader);
    }

    static class JobFunctionTable {
        final ClassLoader classLoader;
        ConcurrentMap<String, Map<Pair<String, String>, Pair<RayFunction, Boolean>>> functions;

        JobFunctionTable(ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.functions = new ConcurrentHashMap<String, Map<Pair<String, String>, Pair<RayFunction, Boolean>>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RayFunction getFunction(JavaFunctionDescriptor descriptor) {
            ImmutablePair key;
            RayFunction func;
            Map<Pair<String, String>, Pair<RayFunction, Boolean>> classFunctions = (Map<Pair<String, String>, Pair<RayFunction, Boolean>>)this.functions.get(descriptor.className);
            if (classFunctions == null) {
                JobFunctionTable jobFunctionTable = this;
                synchronized (jobFunctionTable) {
                    classFunctions = (Map)this.functions.get(descriptor.className);
                    if (classFunctions == null) {
                        classFunctions = this.loadFunctionsForClass(descriptor.className);
                        this.functions.put(descriptor.className, classFunctions);
                    }
                }
            }
            if ((func = (RayFunction)((Pair)classFunctions.get(key = ImmutablePair.of((Object)descriptor.name, (Object)descriptor.signature))).getLeft()) == null) {
                if (classFunctions.containsKey(key)) {
                    throw new RuntimeException(String.format("RayFunction %s is overloaded, the signature can't be empty.", descriptor.toString()));
                }
                throw new RuntimeException(String.format("RayFunction %s not found", descriptor.toString()));
            }
            return func;
        }

        Map<Pair<String, String>, Pair<RayFunction, Boolean>> loadFunctionsForClass(String className) {
            HashMap<Pair<String, String>, Pair<RayFunction, Boolean>> map = new HashMap<Pair<String, String>, Pair<RayFunction, Boolean>>();
            try {
                Class<?> clazz = Class.forName(className, true, this.classLoader);
                ArrayList<Executable> executables = new ArrayList<Executable>();
                executables.addAll(Arrays.asList(clazz.getDeclaredMethods()));
                executables.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
                Class<?> clz = clazz;
                for (clz = clz.getSuperclass(); clz != null && clz != Object.class; clz = clz.getSuperclass()) {
                    executables.addAll(Arrays.asList(clz.getDeclaredMethods()));
                }
                for (Class<?> baseInterface : clazz.getInterfaces()) {
                    for (Method method : baseInterface.getDeclaredMethods()) {
                        if (!method.isDefault()) continue;
                        executables.add(method);
                    }
                }
                for (Executable e : Lists.reverse(executables)) {
                    String[] crossLangSignatures;
                    e.setAccessible(true);
                    String methodName = e instanceof Method ? e.getName() : FunctionManager.CONSTRUCTOR_NAME;
                    Type type = e instanceof Method ? Type.getType((Method)((Method)e)) : Type.getType((Constructor)((Constructor)e));
                    String signature = type.getDescriptor();
                    RayFunction rayFunction = new RayFunction(e, this.classLoader, new JavaFunctionDescriptor(className, methodName, signature));
                    boolean isDefault = e instanceof Method && ((Method)e).isDefault();
                    map.put((Pair<String, String>)ImmutablePair.of((Object)methodName, (Object)signature), (Pair<RayFunction, Boolean>)ImmutablePair.of((Object)rayFunction, (Object)isDefault));
                    for (String crossLangSignature : crossLangSignatures = new String[]{"", String.format("%s", type.getArgumentTypes().length)}) {
                        ImmutablePair crossLangDescriptor = ImmutablePair.of((Object)methodName, (Object)crossLangSignature);
                        if (map.containsKey(crossLangDescriptor) && !((Boolean)((Pair)map.get(crossLangDescriptor)).getRight()).booleanValue()) {
                            map.put((Pair<String, String>)crossLangDescriptor, (Pair<RayFunction, Boolean>)ImmutablePair.of(null, (Object)false));
                            continue;
                        }
                        map.put((Pair<String, String>)crossLangDescriptor, (Pair<RayFunction, Boolean>)ImmutablePair.of((Object)rayFunction, (Object)isDefault));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load functions from class " + className, e);
            }
            return map;
        }
    }
}

