/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.functionmanager;

import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;

public class RayFunction {
    public final Executable executable;
    public final ClassLoader classLoader;
    public final JavaFunctionDescriptor functionDescriptor;

    public RayFunction(Executable executable, ClassLoader classLoader, JavaFunctionDescriptor functionDescriptor) {
        this.executable = executable;
        this.classLoader = classLoader;
        this.functionDescriptor = functionDescriptor;
    }

    public boolean isConstructor() {
        return this.executable instanceof Constructor;
    }

    public Constructor<?> getConstructor() {
        return (Constructor)this.executable;
    }

    public Method getMethod() {
        return (Method)this.executable;
    }

    public JavaFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public boolean hasReturn() {
        if (this.isConstructor()) {
            return true;
        }
        return !this.getMethod().getReturnType().equals(Void.TYPE);
    }

    public Optional<Class<?>> getReturnType() {
        if (this.hasReturn()) {
            return Optional.of(((Method)this.executable).getReturnType());
        }
        return Optional.empty();
    }

    public String toString() {
        return this.executable.toString();
    }
}

