/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.ObjectRef;
import io.ray.api.Ray;
import io.ray.api.id.ObjectId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.object.ObjectSerializer;
import io.ray.shaded.com.google.common.base.FinalizableReferenceQueue;
import io.ray.shaded.com.google.common.base.FinalizableWeakReference;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.Sets;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectRefImpl<T>
implements ObjectRef<T>,
Externalizable {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectRefImpl.class);
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private static final Set<Reference<ObjectRefImpl<?>>> REFERENCES = Sets.newConcurrentHashSet();
    private static ConcurrentHashMap<ObjectId, WeakReference<ObjectRefImpl<?>>> allObjects = new ConcurrentHashMap(1024);
    private ObjectId id;
    private Class<T> type;
    private byte[] rawData = null;

    public ObjectRefImpl(ObjectId id, Class<T> type, boolean skipAddingLocalRef) {
        this.init(id, type, skipAddingLocalRef);
    }

    public ObjectRefImpl(ObjectId id, Class<T> type) {
        this(id, type, false);
    }

    public void init(ObjectId id, Class<?> type, boolean skipAddingLocalRef) {
        this.id = id;
        this.type = type;
        AbstractRayRuntime runtime = (AbstractRayRuntime)Ray.internal();
        if (!skipAddingLocalRef) {
            runtime.getObjectStore().addLocalReference(id);
        }
        new ObjectRefImplReference(this);
    }

    private void setRawData(byte[] rawData) {
        Preconditions.checkState(this.rawData == null);
        this.rawData = rawData;
    }

    public ObjectRefImpl() {
    }

    public synchronized T get() {
        return (T)Ray.get((ObjectRef)this);
    }

    public synchronized T get(long timeoutMs) {
        return (T)Ray.get((ObjectRef)this, (long)timeoutMs);
    }

    public ObjectId getId() {
        return this.id;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return "ObjectRef(" + this.id.toString() + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getId());
        out.writeObject(this.getType());
        AbstractRayRuntime runtime = (AbstractRayRuntime)Ray.internal();
        byte[] ownerAddress = runtime.getObjectStore().getOwnershipInfo(this.getId());
        out.writeInt(ownerAddress.length);
        out.write(ownerAddress);
        ObjectSerializer.addContainedObjectId(this.getId());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (ObjectId)in.readObject();
        this.type = (Class)in.readObject();
        int len = in.readInt();
        byte[] ownerAddress = new byte[len];
        in.readFully(ownerAddress);
        AbstractRayRuntime runtime = (AbstractRayRuntime)Ray.internal();
        runtime.getObjectStore().addLocalReference(this.id);
        new ObjectRefImplReference(this);
        runtime.getObjectStore().registerOwnershipInfoAndResolveFuture(this.id, ObjectSerializer.getOuterObjectId(), ownerAddress);
    }

    private static void onMemoryStoreObjectAllocated(byte[] rawObjectId, byte[] data) {
        ObjectId objectId = new ObjectId(rawObjectId);
        Preconditions.checkState(rawObjectId != null);
        Preconditions.checkState(data != null);
        LOG.debug("onMemoryStoreObjectAllocated: {} , data.length is {}.", (Object)objectId, (Object)data.length);
        if (!allObjects.containsKey(objectId)) {
            LOG.info("The object {} doesn't exist in the weak reference pool", (Object)objectId);
            return;
        }
        WeakReference<ObjectRefImpl<?>> weakRef = allObjects.get(objectId);
        if (weakRef == null) {
            LOG.info("The object {} has already been cleaned.", (Object)objectId);
            allObjects.remove(objectId);
            return;
        }
        ObjectRefImpl objImpl = (ObjectRefImpl)weakRef.get();
        if (objImpl == null) {
            LOG.info("The object {} has already been cleaned.", (Object)objectId);
            allObjects.remove(objectId);
        } else {
            objImpl.setRawData(data);
        }
    }

    public static <T> void registerObjectRefImpl(ObjectId objectId, ObjectRefImpl<T> obj) {
        if (allObjects.containsKey(objectId)) {
            LOG.warn("Duplicated object {}", (Object)objectId);
            return;
        }
        allObjects.put(objectId, new WeakReference<ObjectRefImpl<T>>(obj));
        LOG.debug("Putting object {} to weak reference pool.", (Object)objectId);
    }

    private static final class ObjectRefImplReference
    extends FinalizableWeakReference<ObjectRefImpl<?>> {
        private final ObjectId objectId;
        private final AtomicBoolean removed;

        public ObjectRefImplReference(ObjectRefImpl<?> obj) {
            super(obj, REFERENCE_QUEUE);
            this.objectId = ((ObjectRefImpl)obj).id;
            this.removed = new AtomicBoolean(false);
            REFERENCES.add(this);
        }

        @Override
        public void finalizeReferent() {
            if (!this.removed.getAndSet(true)) {
                REFERENCES.remove(this);
                if (Ray.isInitialized()) {
                    ((AbstractRayRuntime)Ray.internal()).getObjectStore().removeLocalReference(this.objectId);
                    allObjects.remove(this.objectId);
                    LOG.debug("Object {} is finalized.", (Object)this.objectId);
                }
            }
        }
    }
}

