/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayException;
import io.ray.api.exception.RayTaskException;
import io.ray.api.exception.RayWorkerException;
import io.ray.api.exception.UnreconstructableException;
import io.ray.api.id.ActorId;
import io.ray.api.id.ObjectId;
import io.ray.runtime.actor.NativeActorHandle;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.serializer.RayExceptionSerializer;
import io.ray.runtime.serializer.Serializer;
import io.ray.runtime.util.IdUtil;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import io.ray.shaded.com.google.common.primitives.Bytes;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ObjectSerializer {
    private static final byte[] WORKER_EXCEPTION_META = String.valueOf(Common.ErrorType.WORKER_DIED.getNumber()).getBytes();
    private static final byte[] ACTOR_EXCEPTION_META = String.valueOf(Common.ErrorType.ACTOR_DIED.getNumber()).getBytes();
    private static final byte[] UNRECONSTRUCTABLE_EXCEPTION_META = String.valueOf(Common.ErrorType.OBJECT_UNRECONSTRUCTABLE.getNumber()).getBytes();
    private static final byte[] UNRECONSTRUCTABLE_LINEAGE_EVICTED_EXCEPTION_META = String.valueOf(Common.ErrorType.OBJECT_UNRECONSTRUCTABLE_LINEAGE_EVICTED.getNumber()).getBytes();
    private static final byte[] UNRECONSTRUCTABLE_MAX_ATTEMPTS_EXCEEDED_EXCEPTION_META = String.valueOf(Common.ErrorType.OBJECT_UNRECONSTRUCTABLE_MAX_ATTEMPTS_EXCEEDED.getNumber()).getBytes();
    private static final byte[] OBJECT_LOST_META = String.valueOf(Common.ErrorType.OBJECT_LOST.getNumber()).getBytes();
    private static final byte[] OWNER_DIED_META = String.valueOf(Common.ErrorType.OWNER_DIED.getNumber()).getBytes();
    private static final byte[] OBJECT_DELETED_META = String.valueOf(Common.ErrorType.OBJECT_DELETED.getNumber()).getBytes();
    private static final byte[] TASK_EXECUTION_EXCEPTION_META = String.valueOf(Common.ErrorType.TASK_EXECUTION_EXCEPTION.getNumber()).getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_CROSS_LANGUAGE = "XLANG".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_JAVA = "JAVA".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_PYTHON = "PYTHON".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_RAW = "RAW".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_ACTOR_HANDLE = "ACTOR_HANDLE".getBytes();
    static ThreadLocal<Set<ObjectId>> containedObjectIds = ThreadLocal.withInitial(HashSet::new);
    static ThreadLocal<ObjectId> outerObjectId = ThreadLocal.withInitial(() -> null);

    public static Object deserialize(NativeRayObject nativeRayObject, ObjectId objectId, Class<?> objectType) {
        byte[] meta = nativeRayObject.metadata;
        byte[] data = nativeRayObject.data;
        if (meta != null && meta.length > 0) {
            if (Bytes.indexOf(meta, OBJECT_METADATA_TYPE_RAW) == 0) {
                if (objectType == ByteBuffer.class) {
                    return ByteBuffer.wrap(data);
                }
                return data;
            }
            if (Bytes.indexOf(meta, OBJECT_METADATA_TYPE_CROSS_LANGUAGE) == 0 || Bytes.indexOf(meta, OBJECT_METADATA_TYPE_JAVA) == 0) {
                return Serializer.decode(data, objectType);
            }
            if (Bytes.indexOf(meta, WORKER_EXCEPTION_META) == 0) {
                return new RayWorkerException();
            }
            if (Bytes.indexOf(meta, UNRECONSTRUCTABLE_EXCEPTION_META) == 0 || Bytes.indexOf(meta, UNRECONSTRUCTABLE_LINEAGE_EVICTED_EXCEPTION_META) == 0 || Bytes.indexOf(meta, UNRECONSTRUCTABLE_MAX_ATTEMPTS_EXCEEDED_EXCEPTION_META) == 0 || Bytes.indexOf(meta, OBJECT_LOST_META) == 0 || Bytes.indexOf(meta, OWNER_DIED_META) == 0 || Bytes.indexOf(meta, OBJECT_DELETED_META) == 0) {
                return new UnreconstructableException(objectId);
            }
            if (Bytes.indexOf(meta, ACTOR_EXCEPTION_META) == 0) {
                RayException exception;
                ActorId actorId = IdUtil.getActorIdFromObjectId(objectId);
                if (data != null && data.length > 0 && (exception = ObjectSerializer.deserializeActorException(data, actorId, objectId)) != null) {
                    return exception;
                }
                return new RayActorException(actorId);
            }
            if (Bytes.indexOf(meta, TASK_EXECUTION_EXCEPTION_META) == 0) {
                return ObjectSerializer.deserializeRayException(data, objectId);
            }
            if (Bytes.indexOf(meta, OBJECT_METADATA_TYPE_ACTOR_HANDLE) == 0) {
                byte[] serialized = (byte[])Serializer.decode(data, byte[].class);
                return NativeActorHandle.fromBytes(serialized);
            }
            if (Bytes.indexOf(meta, OBJECT_METADATA_TYPE_PYTHON) == 0) {
                throw new IllegalArgumentException("Can't deserialize Python object: " + objectId.toString());
            }
            throw new IllegalArgumentException("Unrecognized metadata " + Arrays.toString(meta));
        }
        return Serializer.decode(data, objectType);
    }

    public static NativeRayObject serialize(Object object) {
        if (object instanceof NativeRayObject) {
            return (NativeRayObject)object;
        }
        if (object instanceof byte[]) {
            return new NativeRayObject((byte[])object, OBJECT_METADATA_TYPE_RAW);
        }
        if (object instanceof ByteBuffer) {
            byte[] bytes;
            ByteBuffer buffer = (ByteBuffer)object;
            if (buffer.hasArray()) {
                bytes = buffer.array();
            } else {
                bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
            }
            return new NativeRayObject(bytes, OBJECT_METADATA_TYPE_RAW);
        }
        if (object instanceof RayTaskException) {
            RayTaskException taskException = (RayTaskException)object;
            byte[] serializedBytes = (byte[])Serializer.encode(RayExceptionSerializer.toBytes((RayException)taskException)).getLeft();
            return new NativeRayObject(serializedBytes, TASK_EXECUTION_EXCEPTION_META);
        }
        if (object instanceof NativeActorHandle) {
            NativeActorHandle actorHandle = (NativeActorHandle)object;
            byte[] serializedBytes = (byte[])Serializer.encode(actorHandle.toBytes()).getLeft();
            NativeRayObject nativeRayObject = new NativeRayObject(serializedBytes, OBJECT_METADATA_TYPE_ACTOR_HANDLE);
            nativeRayObject.setContainedObjectIds(ImmutableList.of(actorHandle.getActorHandleId()));
            return nativeRayObject;
        }
        try {
            Pair<byte[], Boolean> serialized = Serializer.encode(object);
            NativeRayObject nativeRayObject = new NativeRayObject((byte[])serialized.getLeft(), (Boolean)serialized.getRight() != false ? OBJECT_METADATA_TYPE_CROSS_LANGUAGE : OBJECT_METADATA_TYPE_JAVA);
            nativeRayObject.setContainedObjectIds(ObjectSerializer.getAndClearContainedObjectIds());
            return nativeRayObject;
        }
        catch (Exception e) {
            ObjectSerializer.getAndClearContainedObjectIds();
            throw e;
        }
    }

    static void addContainedObjectId(ObjectId objectId) {
        containedObjectIds.get().add(objectId);
    }

    private static List<ObjectId> getAndClearContainedObjectIds() {
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>((Collection)containedObjectIds.get());
        containedObjectIds.get().clear();
        return ids;
    }

    static void setOuterObjectId(ObjectId objectId) {
        outerObjectId.set(objectId);
    }

    static ObjectId getOuterObjectId() {
        return outerObjectId.get();
    }

    static void resetOuterObjectId() {
        outerObjectId.set(null);
    }

    private static RayException deserializeRayException(byte[] msgPackData, ObjectId objectId) {
        byte[] pbData = (byte[])Serializer.decode(msgPackData, byte[].class);
        if (pbData == null || pbData.length == 0) {
            return null;
        }
        try {
            return RayExceptionSerializer.fromBytes(pbData);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't deserialize RayActorCreationTaskException object: " + objectId.toString(), e);
        }
    }

    private static RayException deserializeActorException(byte[] msgPackData, ActorId actorId, ObjectId objectId) {
        byte[] pbData = (byte[])Serializer.decode(msgPackData, byte[].class);
        if (pbData == null || pbData.length == 0) {
            return null;
        }
        try {
            Common.RayErrorInfo rayErrorInfo = Common.RayErrorInfo.parseFrom(pbData);
            if (rayErrorInfo.getActorDiedError().hasCreationTaskFailureContext()) {
                return RayExceptionSerializer.fromRayExceptionPB(rayErrorInfo.getActorDiedError().getCreationTaskFailureContext());
            }
            return new RayActorException(actorId);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't deserialize RayActorCreationTaskException object: " + objectId.toString(), e);
        }
    }
}

