/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.placementgroup;

import io.ray.api.Ray;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.placementgroup.PlacementGroupState;
import io.ray.api.placementgroup.PlacementStrategy;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PlacementGroupImpl
implements PlacementGroup,
Serializable {
    private static final long serialVersionUID = -6616291240442716883L;
    private final PlacementGroupId id;
    private final String name;
    private final List<Map<String, Double>> bundles;
    private final PlacementStrategy strategy;
    private final PlacementGroupState state;

    private PlacementGroupImpl(PlacementGroupId id, String name, List<Map<String, Double>> bundles, PlacementStrategy strategy, PlacementGroupState state) {
        this.id = id;
        this.name = name;
        this.bundles = bundles;
        this.strategy = strategy;
        this.state = state;
    }

    public PlacementGroupId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Map<String, Double>> getBundles() {
        return this.bundles;
    }

    public PlacementStrategy getStrategy() {
        return this.strategy;
    }

    public PlacementGroupState getState() {
        return this.state;
    }

    public boolean wait(int timeoutSeconds) {
        return Ray.internal().waitPlacementGroupReady(this.id, timeoutSeconds);
    }

    public static class Builder {
        private PlacementGroupId id;
        private String name;
        private List<Map<String, Double>> bundles;
        private PlacementStrategy strategy;
        private PlacementGroupState state;

        public Builder setId(PlacementGroupId id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setBundles(List<Map<String, Double>> bundles) {
            this.bundles = bundles;
            return this;
        }

        public Builder setStrategy(PlacementStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder setState(PlacementGroupState state) {
            this.state = state;
            return this;
        }

        public PlacementGroupImpl build() {
            return new PlacementGroupImpl(this.id, this.name, this.bundles, this.strategy, this.state);
        }
    }
}

