/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayException;
import io.ray.api.exception.RayIntentionalSystemExitException;
import io.ray.api.exception.RayTaskException;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.functionmanager.RayFunction;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectSerializer;
import io.ray.runtime.task.ArgumentsBuilder;
import io.ray.runtime.util.NetworkUtil;
import io.ray.runtime.util.SystemUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskExecutor<T extends ActorContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutor.class);
    protected final AbstractRayRuntime runtime;
    private T actorContext = null;
    private final ThreadLocal<RayFunction> localRayFunction = new ThreadLocal();

    TaskExecutor(AbstractRayRuntime runtime) {
        this.runtime = runtime;
    }

    protected abstract T createActorContext();

    T getActorContext() {
        return this.actorContext;
    }

    void setActorContext(UniqueId workerId, T actorContext) {
        if (actorContext == null) {
            return;
        }
        this.actorContext = actorContext;
    }

    private RayFunction getRayFunction(List<String> rayFunctionInfo) {
        JobId jobId = this.runtime.getWorkerContext().getCurrentJobId();
        JavaFunctionDescriptor functionDescriptor = this.parseFunctionDescriptor(rayFunctionInfo);
        return this.runtime.getFunctionManager().getFunction(functionDescriptor);
    }

    protected boolean[] checkByteBufferArguments(List<String> rayFunctionInfo) {
        this.localRayFunction.set(null);
        try {
            this.localRayFunction.set(this.getRayFunction(rayFunctionInfo));
        }
        catch (Throwable e) {
            return null;
        }
        Class<?>[] types = this.localRayFunction.get().executable.getParameterTypes();
        boolean[] results = new boolean[types.length];
        for (int i = 0; i < types.length; ++i) {
            results[i] = types[i] == ByteBuffer.class;
        }
        return results;
    }

    private void throwIfDependencyFailed(Object arg) {
        if (arg instanceof RayException) {
            throw (RayException)arg;
        }
    }

    protected List<NativeRayObject> execute(List<String> rayFunctionInfo, List<Object> argsBytes) {
        Common.TaskType taskType = this.runtime.getWorkerContext().getCurrentTaskType();
        TaskId taskId = this.runtime.getWorkerContext().getCurrentTaskId();
        LOGGER.debug("Executing task {} {}", (Object)taskId, rayFunctionInfo);
        T actorContext = null;
        if (taskType == Common.TaskType.ACTOR_CREATION_TASK) {
            actorContext = this.createActorContext();
            this.setActorContext(this.runtime.getWorkerContext().getCurrentWorkerId(), actorContext);
        } else if (taskType == Common.TaskType.ACTOR_TASK) {
            actorContext = this.getActorContext();
            Preconditions.checkNotNull(actorContext);
        }
        ArrayList<NativeRayObject> returnObjects = new ArrayList<NativeRayObject>();
        RayFunction rayFunction = this.localRayFunction.get();
        Object[] args = null;
        try {
            Object result;
            if (rayFunction == null) {
                rayFunction = this.getRayFunction(rayFunctionInfo);
            }
            Thread.currentThread().setContextClassLoader(rayFunction.classLoader);
            Object actor = null;
            if (taskType == Common.TaskType.ACTOR_TASK) {
                actor = ((ActorContext)actorContext).currentActor;
            }
            for (Object arg2 : args = ArgumentsBuilder.unwrap(argsBytes, rayFunction.executable.getParameterTypes())) {
                this.throwIfDependencyFailed(arg2);
            }
            try {
                result = !rayFunction.isConstructor() ? rayFunction.getMethod().invoke(actor, args) : rayFunction.getConstructor().newInstance(args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            if (taskType != Common.TaskType.ACTOR_CREATION_TASK) {
                if (rayFunction.hasReturn()) {
                    returnObjects.add(ObjectSerializer.serialize(result));
                }
            } else {
                ((ActorContext)actorContext).currentActor = result;
            }
            LOGGER.debug("Finished executing task {}", (Object)taskId);
        }
        catch (Throwable e) {
            if (e instanceof RayIntentionalSystemExitException) {
                throw (RayIntentionalSystemExitException)e;
            }
            List argTypes = args == null ? null : Arrays.stream(args).map(arg -> arg == null ? null : arg.getClass()).collect(Collectors.toList());
            LOGGER.error("Failed to execute task {} . rayFunction is {} , argument types are {}", new Object[]{taskId, rayFunction, argTypes, e});
            if (taskType != Common.TaskType.ACTOR_CREATION_TASK) {
                boolean hasReturn = rayFunction != null && rayFunction.hasReturn();
                boolean isCrossLanguage = this.parseFunctionDescriptor(rayFunctionInfo).signature.equals("");
                if (hasReturn || isCrossLanguage) {
                    NativeRayObject serializedException;
                    try {
                        serializedException = ObjectSerializer.serialize(new RayTaskException(SystemUtil.pid(), NetworkUtil.getIpAddress(null), "Error executing task " + taskId, e));
                    }
                    catch (Exception unserializable) {
                        LOGGER.warn("Failed to serialize the exception to a RayObject.", (Throwable)unserializable);
                        serializedException = ObjectSerializer.serialize(new RayTaskException(String.format("Error executing task %s with the exception: %s", taskId, ExceptionUtils.getStackTrace((Throwable)e))));
                    }
                    Preconditions.checkNotNull(serializedException);
                    returnObjects.add(serializedException);
                }
                returnObjects.add(ObjectSerializer.serialize(new RayTaskException(SystemUtil.pid(), NetworkUtil.getIpAddress(null), String.format("Function %s of task %s doesn't exist", String.join((CharSequence)".", rayFunctionInfo), taskId), e)));
            }
            throw new RayActorException(SystemUtil.pid(), NetworkUtil.getIpAddress(null), e);
        }
        return returnObjects;
    }

    private JavaFunctionDescriptor parseFunctionDescriptor(List<String> rayFunctionInfo) {
        Preconditions.checkState(rayFunctionInfo != null && rayFunctionInfo.size() == 3);
        return new JavaFunctionDescriptor(rayFunctionInfo.get(0), rayFunctionInfo.get(1), rayFunctionInfo.get(2));
    }

    static class ActorContext {
        Object currentActor = null;

        ActorContext() {
        }
    }
}

