/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import com.sun.jna.NativeLibrary;
import io.ray.runtime.util.BinaryFileUtil;
import io.ray.shaded.com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JniUtils.class);
    private static Set<String> loadedLibs = Sets.newHashSet();
    private static String defaultDestDir;

    public static synchronized void loadLibrary(String libraryName) {
        JniUtils.loadLibrary(JniUtils.getDefaultDestDir(), libraryName);
    }

    public static synchronized void loadLibrary(String libraryName, boolean exportSymbols) {
        JniUtils.loadLibrary(JniUtils.getDefaultDestDir(), libraryName, exportSymbols);
    }

    public static synchronized void loadLibrary(String destDir, String libraryName) {
        JniUtils.loadLibrary(destDir, libraryName, false);
    }

    public static synchronized void loadLibrary(String destDir, String libraryName, boolean exportSymbols) {
        if (!loadedLibs.contains(libraryName)) {
            LOGGER.debug("Loading native library {} in {}.", (Object)libraryName, (Object)destDir);
            String fileName = System.mapLibraryName(libraryName);
            File file = BinaryFileUtil.getNativeFile(destDir, fileName);
            if (exportSymbols) {
                NativeLibrary.getInstance((String)file.getAbsolutePath());
            }
            System.load(file.getAbsolutePath());
            LOGGER.debug("Native library loaded.");
            loadedLibs.add(libraryName);
        }
    }

    private static synchronized String getDefaultDestDir() {
        if (defaultDestDir == null) {
            try {
                defaultDestDir = Files.createTempDirectory("native_libs", new FileAttribute[0]).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return defaultDestDir;
    }
}

