/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.awssdk.converters;

import io.reactiverse.awssdk.reactivestreams.WriteStreamSubscriber;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;

public class VertxAsyncResponseTransformer<ResponseT>
implements AsyncResponseTransformer<ResponseT, WriteStream<Buffer>> {
    private volatile CompletableFuture<WriteStream<Buffer>> cf;
    private volatile WriteStream<Buffer> writeStream;
    private volatile Optional<Handler<ResponseT>> responseHandler;

    public VertxAsyncResponseTransformer(WriteStream<Buffer> ws) {
        this.writeStream = ws;
        this.responseHandler = Optional.empty();
    }

    public CompletableFuture<WriteStream<Buffer>> prepare() {
        this.cf = new CompletableFuture();
        return this.cf;
    }

    public void onResponse(ResponseT response) {
        this.responseHandler.ifPresent(handler -> handler.handle(response));
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe(new WriteStreamSubscriber<WriteStream<Buffer>>(this.writeStream, this.cf));
    }

    public void exceptionOccurred(Throwable error) {
        this.cf.completeExceptionally(error);
    }

    public VertxAsyncResponseTransformer<ResponseT> setResponseHandler(Handler<ResponseT> handler) {
        this.responseHandler = Optional.of(handler);
        return this;
    }
}

