/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.awssdk.reactivestreams;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WriteStreamSubscriber<T extends WriteStream<Buffer>>
implements Subscriber<ByteBuffer> {
    protected static final long BUFF_SIZE = 1024L;
    protected T stream;
    private Subscription subscription;
    private Optional<CompletableFuture<WriteStream<Buffer>>> cf;

    public WriteStreamSubscriber(T stream) {
        this.stream = stream;
        this.cf = Optional.empty();
    }

    public WriteStreamSubscriber(T stream, CompletableFuture<WriteStream<Buffer>> cf) {
        this.stream = stream;
        this.cf = Optional.of(cf);
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1024L);
    }

    public void onNext(ByteBuffer byteBuffer) {
        if (byteBuffer.array().length != 0) {
            Buffer buffer = Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
            this.stream.write((Object)buffer);
        }
        this.subscription.request(1024L);
    }

    public void onError(Throwable t) {
        this.subscription.cancel();
    }

    public void onComplete() {
        this.stream.end();
        this.cf.map(fut -> fut.complete(this.stream));
    }
}

