/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.awssdk;

import io.reactiverse.awssdk.converters.MethodConverter;
import io.reactiverse.awssdk.reactivestreams.HttpClientRequestSubscriber;
import io.reactiverse.awssdk.reactivestreams.ReadStreamPublisher;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.StringUtils;

public class VertxNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private final Context context;
    private final HttpClient client;
    private final HttpClientOptions clientOptions;
    private static final HttpClientOptions DEFAULT_CLIENT_OPTIONS = new HttpClientOptions().setSsl(true).setKeepAlive(true);

    public VertxNioAsyncHttpClient(Context context) {
        this.context = context;
        this.clientOptions = DEFAULT_CLIENT_OPTIONS;
        this.client = this.createVertxHttpClient(context.owner());
    }

    public VertxNioAsyncHttpClient(Context context, HttpClientOptions clientOptions) {
        Objects.requireNonNull(clientOptions);
        this.context = context;
        this.clientOptions = clientOptions;
        this.client = this.createVertxHttpClient(context.owner());
    }

    private HttpClient createVertxHttpClient(Vertx vertx) {
        return vertx.createHttpClient(this.clientOptions);
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncExecuteRequest) {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        if (Context.isOnEventLoopThread()) {
            this.executeOnContext(asyncExecuteRequest, fut);
        } else {
            this.context.runOnContext(v -> this.executeOnContext(asyncExecuteRequest, fut));
        }
        return fut;
    }

    void executeOnContext(AsyncExecuteRequest asyncExecuteRequest, CompletableFuture<Void> fut) {
        SdkHttpRequest request = asyncExecuteRequest.request();
        SdkAsyncHttpResponseHandler responseHandler = asyncExecuteRequest.responseHandler();
        RequestOptions options = VertxNioAsyncHttpClient.getRequestOptions(request);
        this.client.request(options, ar -> {
            if (ar.failed()) {
                responseHandler.onError(ar.cause());
                return;
            }
            HttpClientRequest vRequest = (HttpClientRequest)ar.result();
            vRequest.response(res -> {
                if (res.failed()) {
                    responseHandler.onError(res.cause());
                    fut.completeExceptionally(res.cause());
                    return;
                }
                HttpClientResponse vResponse = (HttpClientResponse)res.result();
                SdkHttpFullResponse.Builder builder = SdkHttpResponse.builder().statusCode(vResponse.statusCode()).statusText(vResponse.statusMessage());
                vResponse.headers().forEach(e -> builder.appendHeader((String)e.getKey(), (String)e.getValue()));
                responseHandler.onHeaders((SdkHttpResponse)builder.build());
                responseHandler.onStream(new ReadStreamPublisher(vResponse, fut));
            });
            SdkHttpContentPublisher publisher = asyncExecuteRequest.requestContentPublisher();
            if (publisher != null) {
                publisher.subscribe((Subscriber)new HttpClientRequestSubscriber(vRequest));
            } else {
                vRequest.end();
            }
        });
    }

    private static RequestOptions getRequestOptions(SdkHttpRequest request) {
        RequestOptions options = new RequestOptions().setMethod(MethodConverter.awsToVertx(request.method())).setHost(request.host()).setPort(Integer.valueOf(request.port())).setURI(VertxNioAsyncHttpClient.createRelativeUri(request.getUri())).setFollowRedirects(Boolean.valueOf(true)).setSsl(Boolean.valueOf("https".equals(request.protocol())));
        request.headers().forEach((name, values) -> options.addHeader((CharSequence)name, (Iterable)values.stream().map(s -> s).collect(Collectors.toList())));
        options.addHeader(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        return options;
    }

    private static String createRelativeUri(URI uri) {
        return (StringUtils.isEmpty((CharSequence)uri.getPath()) ? "/" : uri.getPath()) + (StringUtils.isEmpty((CharSequence)uri.getQuery()) ? "" : "?" + uri.toASCIIString().split("\\?")[1]);
    }

    public void close() {
        this.client.close();
    }
}

