/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.awssdk.reactivestreams;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReadStreamPublisher<T extends Buffer>
implements Publisher<ByteBuffer> {
    private ReadStream<T> stream;
    private CompletableFuture<Void> future;

    public ReadStreamPublisher(ReadStream<T> readStream) {
        this(readStream, null);
    }

    public ReadStreamPublisher(ReadStream<T> readStream, CompletableFuture<Void> future) {
        this.stream = readStream;
        this.future = future;
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        s.onSubscribe(new Subscription(){

            public void request(long n) {
                ReadStreamPublisher.this.stream.fetch(n);
            }

            public void cancel() {
            }
        });
        this.stream.endHandler(v -> {
            s.onComplete();
            if (this.future != null) {
                this.future.complete(null);
            }
        });
        this.stream.handler(buff -> s.onNext((Object)ByteBuffer.wrap(buff.getBytes())));
        this.stream.exceptionHandler(arg_0 -> s.onError(arg_0));
    }
}

