/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import io.vertx.spi.cluster.consul.impl.ChoosableSet;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class CcmIssue14Replicator {
    private static final String EVENT_BUS_ADDRESS = "abc-addr";

    public static void main(String[] args) {
        ChoosableSet choosableSet = new ChoosableSet(3);
        choosableSet.add((Object)1);
        choosableSet.add((Object)2);
        choosableSet.add((Object)3);
        System.out.println(choosableSet.choose());
        System.out.println(choosableSet.choose());
        System.out.println(choosableSet.choose());
        System.out.println(choosableSet.choose());
        HashSet<Integer> integers = new HashSet<Integer>();
        integers.add(1);
        ChoosableSet a = choosableSet.copy(integers);
        System.out.println(a.choose());
        System.out.println(a.choose());
    }

    public static void main1(String[] args) {
        AtomicReference vertxInstance1 = new AtomicReference();
        AtomicReference vertxInstance2 = new AtomicReference();
        AtomicReference vertxInstance3 = new AtomicReference();
        CcmIssue14Replicator.createClusteredVertxInstance().compose(vertx -> {
            vertxInstance1.set(vertx);
            System.out.println("Node 1 is up and running...");
            vertx.eventBus().consumer(EVENT_BUS_ADDRESS, event -> System.out.println("Node 1 is processing: " + event.body()));
            return Future.succeededFuture();
        }).compose(o -> CcmIssue14Replicator.createClusteredVertxInstance()).compose(vertx -> {
            vertxInstance2.set(vertx);
            System.out.println("Node 2 is up and running...");
            vertx.eventBus().consumer(EVENT_BUS_ADDRESS, event -> System.out.println("Node 2 is processing: " + event.body()));
            return Future.succeededFuture();
        }).compose(o -> CcmIssue14Replicator.createClusteredVertxInstance()).compose(vertx -> {
            vertxInstance3.set(vertx);
            System.out.println("Node 3 is up and running...");
            vertx.eventBus().consumer(EVENT_BUS_ADDRESS, event -> System.out.println("Node 3 is processing: " + event.body()));
            return Future.succeededFuture((Object)vertx);
        }).compose(vertx -> {
            Promise promise = Promise.promise();
            vertx.executeBlocking(event -> {
                try {
                    Thread.sleep(3000L);
                    event.complete((Object)"");
                }
                catch (InterruptedException e) {
                    event.fail((Throwable)e);
                }
            }, res -> promise.complete());
            return promise.future();
        }).compose(o -> {
            String node1Message = UUID.randomUUID().toString();
            System.out.println("Node 1 is firing a message: " + node1Message);
            ((Vertx)vertxInstance1.get()).eventBus().request(EVENT_BUS_ADDRESS, (Object)node1Message, event -> {});
            System.out.println("Node 1 is firing a message: " + node1Message);
            ((Vertx)vertxInstance1.get()).eventBus().request(EVENT_BUS_ADDRESS, (Object)node1Message, event -> {});
            System.out.println("Node 1 is firing a message: " + node1Message);
            ((Vertx)vertxInstance1.get()).eventBus().request(EVENT_BUS_ADDRESS, (Object)node1Message, event -> {});
            return Future.succeededFuture();
        });
    }

    private static Future<Vertx> createClusteredVertxInstance() {
        Promise promise = Promise.promise();
        JsonObject config = new JsonObject();
        config.put("preferConsistency", Boolean.valueOf(true));
        ConsulClusterManager manager = new ConsulClusterManager(config);
        VertxOptions options = new VertxOptions();
        options.setClusterManager((ClusterManager)manager);
        Vertx.clusteredVertx((VertxOptions)options, event -> {
            if (event.succeeded()) {
                promise.complete(event.result());
            } else {
                promise.fail(event.cause());
            }
        });
        return promise.future();
    }
}

