/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.eventbus.impl.clustered.ClusterNodeInfo;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.shareddata.AsyncMultiMapTest;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;

public class ConsulAsyncBaseMultiMapTest
extends AsyncMultiMapTest {
    protected volatile AsyncMultiMap<String, ClusterNodeInfo> clusterNodeIdMap;

    public void setUp() throws Exception {
        super.setUp();
        CountDownLatch latch = new CountDownLatch(1);
        this.clusterManager.getAsyncMultiMap("clusterNodeIdMap", this.onSuccess(res -> {
            this.clusterNodeIdMap = res;
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testAddAndGetClusterNodeInfo() {
        ClusterNodeInfo clusterNodeAInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8080, "localhost"));
        ClusterNodeInfo clusterNodeBInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8081, "localhost"));
        String address = "testAddAndGetClusterNodeInfo";
        this.clusterNodeIdMap.add((Object)address, (Object)clusterNodeAInfo, cHandler_1 -> {
            this.assertTrue(cHandler_1.succeeded());
            this.clusterNodeIdMap.add((Object)address, (Object)clusterNodeBInfo, cHandler_2 -> {
                this.assertTrue(cHandler_2.succeeded());
                this.clusterNodeIdMap.get((Object)address, resultHandler -> {
                    this.assertTrue(resultHandler.succeeded());
                    Set expectedNodeSet = Stream.of(clusterNodeAInfo, clusterNodeBInfo).collect(Collectors.toSet());
                    ChoosableIterable result = (ChoosableIterable)resultHandler.result();
                    result.forEach(clusterNodeInfo -> this.assertTrue(expectedNodeSet.contains(clusterNodeAInfo)));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testRemoveClusterNodeInfo() {
        ClusterNodeInfo clusterNodeAInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8080, "localhost"));
        ClusterNodeInfo clusterNodeBInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8081, "localhost"));
        String address = "testRemoveClusterNodeInfo";
        this.clusterNodeIdMap.add((Object)address, (Object)clusterNodeAInfo, cHandler_1 -> {
            this.assertTrue(cHandler_1.succeeded());
            this.clusterNodeIdMap.add((Object)address, (Object)clusterNodeBInfo, cHandler_2 -> {
                this.assertTrue(cHandler_2.succeeded());
                ClusterNodeInfo notExistingClusterNodeInfo = new ClusterNodeInfo(UUID.randomUUID().toString(), new ServerID(1111, "localhost"));
                this.clusterNodeIdMap.remove((Object)address, (Object)notExistingClusterNodeInfo, cHandler_3 -> {
                    this.assertTrue(cHandler_3.succeeded());
                    this.assertFalse((Boolean)cHandler_3.result());
                    this.clusterNodeIdMap.get((Object)address, rHandler_1 -> {
                        this.assertTrue(rHandler_1.succeeded());
                        Set expectedNodeSet = Stream.of(clusterNodeAInfo, clusterNodeBInfo).collect(Collectors.toSet());
                        ((ChoosableIterable)rHandler_1.result()).forEach(clusterNodeInfo -> this.assertTrue(expectedNodeSet.contains(clusterNodeAInfo)));
                        this.clusterNodeIdMap.remove((Object)address, (Object)clusterNodeBInfo, cHandler_4 -> {
                            this.assertTrue(cHandler_4.succeeded());
                            this.assertTrue((Boolean)cHandler_4.result());
                            this.clusterNodeIdMap.get((Object)address, rHandler_2 -> {
                                this.assertTrue(rHandler_2.succeeded());
                                ArrayList receivedSet = new ArrayList();
                                ((ChoosableIterable)rHandler_2.result()).forEach(clusterNodeInfo -> receivedSet.add(clusterNodeAInfo));
                                this.assertEquals(receivedSet.get(0), clusterNodeAInfo);
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testRemoveAllForValueClusterNodeInfo() {
        String users = "users.removeAllForValue";
        ClusterNodeInfo usersNodeASub = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8080, "192.168.0.1"));
        ClusterNodeInfo usersNodeBSub = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8081, "192.168.0.2"));
        String posts = "posts.removeAllForValue";
        ClusterNodeInfo postsNodeASub = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8080, "192.168.0.1"));
        ClusterNodeInfo postsNodeBSub = new ClusterNodeInfo(this.clusterManager.getNodeID(), new ServerID(8081, "192.168.0.2"));
        this.clusterNodeIdMap.add((Object)users, (Object)usersNodeASub, handler_1 -> {
            this.assertTrue(handler_1.succeeded());
            this.clusterNodeIdMap.add((Object)users, (Object)usersNodeBSub, handler_2 -> {
                this.assertTrue(handler_2.succeeded());
                this.clusterNodeIdMap.add((Object)posts, (Object)postsNodeASub, handler_3 -> {
                    this.assertTrue(handler_3.succeeded());
                    this.clusterNodeIdMap.add((Object)posts, (Object)postsNodeBSub, handler_4 -> {
                        this.assertTrue(handler_4.succeeded());
                        this.clusterNodeIdMap.removeAllForValue((Object)usersNodeASub, rHandler -> {
                            this.assertTrue(rHandler.succeeded());
                            this.clusterNodeIdMap.get((Object)users, usersSubs -> {
                                this.assertTrue(usersSubs.succeeded());
                                Set expectedNodeSet = Stream.of(usersNodeBSub).collect(Collectors.toSet());
                                ((ChoosableIterable)usersSubs.result()).forEach(clusterNodeInfo -> this.assertTrue(expectedNodeSet.contains(clusterNodeInfo)));
                                this.clusterNodeIdMap.get((Object)posts, postsSubs -> {
                                    this.assertTrue(postsSubs.succeeded());
                                    Set expectedNodeBSet = Stream.of(postsNodeBSub).collect(Collectors.toSet());
                                    ((ChoosableIterable)postsSubs.result()).forEach(clusterNodeInfo -> this.assertTrue(expectedNodeBSet.contains(clusterNodeInfo)));
                                    this.testComplete();
                                });
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }
}

