/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.ClusteredAsyncMapTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsulClusteredAsyncMapTest
extends ClusteredAsyncMapTest {
    private ConsulClient consulClient;
    private static int port = 8500;

    @BeforeClass
    public static void startConsulCluster() {
        port = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getConsulClusterManagerOptions());
    }

    public void before() throws Exception {
        super.before();
        if (this.consulClient == null) {
            this.consulClient = ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)new ConsulClientOptions(this.getConsulClusterManagerOptions()));
        }
    }

    public void after() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.consulClient.deleteValues("foo", event -> latch.countDown());
        this.consulClient.deleteValues("bar", event -> latch.countDown());
        latch.await();
        super.after();
    }

    @Test
    public void testMapPutGetDoubleSlash() {
        this.getVertx().sharedData().getAsyncMap("foo", asyncMapHandler -> {
            this.assertTrue(asyncMapHandler.succeeded());
            this.assertNotNull(asyncMapHandler.result());
            ((AsyncMap)asyncMapHandler.result()).put((Object)"//key", (Object)"value", handler -> {
                this.assertTrue(handler.failed());
                this.assertTrue(handler.cause().getMessage().contains("Moved Permanently"));
                this.complete();
            });
        });
        this.await();
    }

    private JsonObject getConsulClusterManagerOptions() {
        return new JsonObject().put("host", "localhost").put("port", Integer.valueOf(port));
    }
}

