/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import io.vertx.spi.cluster.consul.impl.ChoosableSet;
import io.vertx.spi.cluster.consul.impl.ConsulAsyncMultiMap;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsulClusteredAsyncMultiMapTest
extends VertxTestBase {
    private ClusterManager[] clusterManagers;
    private volatile AsyncMultiMap<String, ServerID>[] maps;
    private static int port;

    @BeforeClass
    public static void startConsulCluster() {
        port = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(2);
        this.clusterManagers = new ClusterManager[2];
        this.maps = new ConsulAsyncMultiMap[2];
        this.clusterManagers[0] = ((VertxInternal)this.vertices[0]).getClusterManager();
        this.clusterManagers[1] = ((VertxInternal)this.vertices[1]).getClusterManager();
        CountDownLatch latch = new CountDownLatch(2);
        this.clusterManagers[0].getAsyncMultiMap("subs", this.onSuccess(res -> {
            this.maps[0] = res;
            latch.countDown();
        }));
        this.clusterManagers[1].getAsyncMultiMap("subs", this.onSuccess(res -> {
            this.maps[1] = res;
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getConsulClusterManagerOptions());
    }

    @Test
    public void testAddAndGet() {
        String addressLviv = "Lviv";
        String addressCherche = "LvivCherche";
        this.maps[0].add((Object)addressLviv, (Object)new ServerID(10, "localhost"), res_10 -> {
            this.assertTrue(res_10.succeeded());
            this.maps[0].add((Object)addressCherche, (Object)new ServerID(11, "localhost"), res_11 -> {
                this.assertTrue(res_11.succeeded());
                this.maps[0].get((Object)addressLviv, res_20 -> {
                    this.assertTrue(res_20.succeeded());
                    ChoosableSet result_20 = (ChoosableSet)res_20.result();
                    this.assertNotNull(result_20);
                    this.assertEquals(1L, result_20.size());
                    this.maps[1].get((Object)addressLviv, res_3 -> {
                        this.assertTrue(res_3.succeeded());
                        ChoosableSet result_30 = (ChoosableSet)res_3.result();
                        this.assertNotNull(result_30);
                        this.assertEquals(1L, result_30.size());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    private JsonObject getConsulClusterManagerOptions() {
        return new JsonObject().put("host", "localhost").put("port", Integer.valueOf(port));
    }
}

