/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusteredSharedCounterTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class ConsulClusteredSharedCounterTest
extends ClusteredSharedCounterTest {
    private ConsulClient consulClient;
    private static int port;

    @BeforeClass
    public static void startConsulCluster() {
        port = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getClusterManagerOptions());
    }

    public void before() throws Exception {
        super.before();
        if (this.consulClient == null) {
            this.consulClient = ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)new ConsulClientOptions(this.getClusterManagerOptions()));
        }
    }

    public void after() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.consulClient.deleteValues("__vertx.counters", event -> latch.countDown());
        latch.await();
        super.after();
    }

    private JsonObject getClusterManagerOptions() {
        return new JsonObject().put("host", "localhost").put("port", Integer.valueOf(port));
    }
}

