/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.web.sstore.ClusteredSessionHandlerTest;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import io.vertx.spi.cluster.consul.Utils;
import java.util.function.Consumer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ConsulClusteredSessionHandlerTest
extends ClusteredSessionHandlerTest {
    private static final int DEFAULT_PORT = Utils.getFreePort();
    private static int consulAgentPort = 8500;

    @BeforeClass
    public static void startConsulCluster() {
        consulAgentPort = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getClusterManagerOptions());
    }

    protected HttpServerOptions getHttpServerOptions() {
        return new HttpServerOptions().setPort(DEFAULT_PORT).setHost("localhost");
    }

    protected HttpClientOptions getHttpClientOptions() {
        return new HttpClientOptions().setDefaultPort(DEFAULT_PORT);
    }

    protected void testRequestBuffer(HttpMethod method, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer, boolean normalizeLineEndings) throws Exception {
        this.testRequestBuffer(this.client, method, DEFAULT_PORT, path, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, normalizeLineEndings);
    }

    private JsonObject getClusterManagerOptions() {
        return new JsonObject().put("host", "localhost").put("port", Integer.valueOf(consulAgentPort));
    }

    @Test
    @Ignore(value="Not supported")
    public void testRetryTimeout() throws Exception {
        super.testRetryTimeout();
    }
}

