/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.consul.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import io.vertx.test.core.VertxTestBase;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsulNodeWithSpecifiedHostNameTest
extends VertxTestBase {
    private static int consulAgentPort = 8500;
    private static final String EXPLICIT_NODE_ADDRESS = "localhost";
    private ConsulClient externalConsulClient;

    @BeforeClass
    public static void startConsulCluster() {
        consulAgentPort = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(1);
        this.externalConsulClient = ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)new ConsulClientOptions(this.getConfig()));
    }

    @Test
    public void testDefaultNodeHostAddress() {
        this.externalConsulClient.getValues("__vertx.nodes", nodesResultHandler -> {
            this.assertTrue(nodesResultHandler.succeeded());
            this.assertNotNull(nodesResultHandler.result());
            this.assertNotNull(((KeyValueList)nodesResultHandler.result()).getList());
            this.assertEquals(1L, ((KeyValueList)nodesResultHandler.result()).getList().size());
            this.assertTrue(((KeyValue)((KeyValueList)nodesResultHandler.result()).getList().get(0)).getValue() != null);
            this.assertFalse(((KeyValue)((KeyValueList)nodesResultHandler.result()).getList().get(0)).getValue().isEmpty());
            JsonObject nodeAddress = new JsonObject(((KeyValue)((KeyValueList)nodesResultHandler.result()).getList().get(0)).getValue());
            this.assertEquals(EXPLICIT_NODE_ADDRESS, nodeAddress.getString("host"));
            this.externalConsulClient.healthChecks("vert.x-cluster-manager", checksResultHandler -> {
                this.assertTrue(checksResultHandler.succeeded());
                this.assertNotNull(checksResultHandler.result());
                List checkList = ((CheckList)checksResultHandler.result()).getList();
                this.assertNotNull(checkList);
                this.assertEquals(1L, checkList.size());
                this.assertEquals(CheckStatus.PASSING, ((Check)checkList.get(0)).getStatus());
                this.complete();
            });
        });
        this.await();
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getConfig());
    }

    public void after() throws Exception {
        super.after();
        this.externalConsulClient.close();
    }

    private JsonObject getConfig() {
        return new JsonObject().put("host", EXPLICIT_NODE_ADDRESS).put("port", Integer.valueOf(consulAgentPort)).put("nodeHost", EXPLICIT_NODE_ADDRESS);
    }
}

