/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.consul.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.ServiceList;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.ConsulClusterManager;
import io.vertx.test.core.VertxTestBase;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsulServiceNameTest
extends VertxTestBase {
    private static int consulAgentPort = 8500;
    private final String customServiceName = "customServiceName";
    private ConsulClient externalConsulClient;

    @BeforeClass
    public static void startConsulCluster() {
        consulAgentPort = ConsulCluster.init();
    }

    @AfterClass
    public static void shutDownConsulCluster() {
        ConsulCluster.shutDown();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(1);
        this.externalConsulClient = ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)new ConsulClientOptions(this.getConfig()));
    }

    @Test
    public void testCustomServiceName() {
        this.externalConsulClient.catalogServices(serviceResultHandler -> {
            this.assertTrue(serviceResultHandler.succeeded());
            ServiceList result = (ServiceList)serviceResultHandler.result();
            this.assertNotNull(result);
            List list = result.getList();
            this.assertNotNull(list);
            this.assertEquals(2L, list.size());
            this.assertTrue(list.stream().anyMatch(service -> service.getName().equals("customServiceName")));
            this.complete();
        });
        this.await();
    }

    protected ClusterManager getClusterManager() {
        return new ConsulClusterManager(this.getConfig());
    }

    public void after() throws Exception {
        super.after();
        this.externalConsulClient.close();
    }

    private JsonObject getConfig() {
        return new JsonObject().put("serviceName", "customServiceName").put("host", "localhost").put("port", Integer.valueOf(consulAgentPort));
    }
}

