/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.consul.impl;

import io.vertx.core.Vertx;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.SessionBehavior;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.spi.cluster.consul.ConsulCluster;
import io.vertx.spi.cluster.consul.impl.ClusterManagerInternalContext;
import io.vertx.spi.cluster.consul.impl.ConsulSyncMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsulSyncMapTest {
    private ClusterManagerInternalContext cmContext;
    private int port;

    @Before
    public void setUp() {
        this.cmContext = new ClusterManagerInternalContext();
        this.port = ConsulCluster.init();
        ConsulClientOptions options = new ConsulClientOptions().setPort(this.port).setHost("localhost");
        this.cmContext.setVertx(Vertx.vertx()).setConsulClientOptions(options).initConsulClient().setNodeId("testSyncMapNodeId").setEphemeralSessionId(this.getSessionId());
    }

    @Test
    public void syncMapOperation() {
        String k = "myKey";
        String v = "myValue";
        ConsulSyncMap syncMap = new ConsulSyncMap("syncMapTest", this.cmContext);
        syncMap.put((Object)k, (Object)v);
        Assert.assertFalse((boolean)syncMap.isEmpty());
        Assert.assertEquals((Object)syncMap.get((Object)k), (Object)v);
        Assert.assertTrue((syncMap.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)syncMap.containsKey((Object)k));
        Assert.assertTrue((boolean)syncMap.containsValue((Object)v));
        Assert.assertTrue((boolean)syncMap.keySet().contains(k));
        Assert.assertTrue((boolean)syncMap.values().contains(v));
        syncMap.entrySet().forEach(entry -> {
            Assert.assertEquals((Object)k, entry.getKey());
            Assert.assertEquals((Object)v, entry.getValue());
        });
        String value = (String)syncMap.remove((Object)k);
        Assert.assertEquals((Object)value, (Object)v);
        Assert.assertNull((Object)syncMap.get((Object)k));
        syncMap.clear();
        Assert.assertTrue((boolean)syncMap.isEmpty());
    }

    @After
    public void tearDown() {
        this.destroySessionId();
        this.cmContext.getVertx().close();
        this.cmContext.getConsulClient().close();
        ConsulCluster.shutDown();
    }

    private String getSessionId() {
        CompletableFuture future = new CompletableFuture();
        SessionOptions sessionOptions = new SessionOptions().setBehavior(SessionBehavior.DELETE).setLockDelay(0L).setName("test");
        this.cmContext.getConsulClient().createSessionWithOptions(sessionOptions, resultHandler -> {
            if (resultHandler.succeeded()) {
                future.complete(resultHandler.result());
            } else {
                future.completeExceptionally(resultHandler.cause());
            }
        });
        String sId = null;
        try {
            sId = (String)future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail((String)e.getMessage());
        }
        return sId;
    }

    private void destroySessionId() {
        CountDownLatch latch = new CountDownLatch(1);
        this.cmContext.getConsulClient().destroySession(this.cmContext.getEphemeralSessionId(), event -> latch.countDown());
        try {
            latch.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

