/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.CcrClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.ccr.CcrStatsRequest;
import org.elasticsearch.client.ccr.CcrStatsResponse;
import org.elasticsearch.client.ccr.DeleteAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.FollowInfoRequest;
import org.elasticsearch.client.ccr.FollowInfoResponse;
import org.elasticsearch.client.ccr.FollowStatsRequest;
import org.elasticsearch.client.ccr.FollowStatsResponse;
import org.elasticsearch.client.ccr.ForgetFollowerRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternResponse;
import org.elasticsearch.client.ccr.PauseAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.client.ccr.PutFollowResponse;
import org.elasticsearch.client.ccr.ResumeAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.ResumeFollowRequest;
import org.elasticsearch.client.ccr.UnfollowRequest;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.core.BroadcastResponse;

class CcrClientImpl
implements CcrClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.CcrClient delegate;

    CcrClientImpl(Vertx vertx, org.elasticsearch.client.CcrClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putFollowAsync(PutFollowRequest request, RequestOptions options, final Handler<AsyncResult<PutFollowResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putFollowAsync(request, options, (ActionListener)new ActionListener<PutFollowResponse>(){

            public void onResponse(PutFollowResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void pauseFollowAsync(PauseFollowRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.pauseFollowAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void resumeFollowAsync(ResumeFollowRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.resumeFollowAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void unfollowAsync(UnfollowRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.unfollowAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void forgetFollowerAsync(ForgetFollowerRequest request, RequestOptions options, final Handler<AsyncResult<BroadcastResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.forgetFollowerAsync(request, options, (ActionListener)new ActionListener<BroadcastResponse>(){

            public void onResponse(BroadcastResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putAutoFollowPatternAsync(PutAutoFollowPatternRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putAutoFollowPatternAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAutoFollowPatternAsync(DeleteAutoFollowPatternRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAutoFollowPatternAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAutoFollowPatternAsync(GetAutoFollowPatternRequest request, RequestOptions options, final Handler<AsyncResult<GetAutoFollowPatternResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAutoFollowPatternAsync(request, options, (ActionListener)new ActionListener<GetAutoFollowPatternResponse>(){

            public void onResponse(GetAutoFollowPatternResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void pauseAutoFollowPatternAsync(PauseAutoFollowPatternRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.pauseAutoFollowPatternAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void resumeAutoFollowPatternAsync(ResumeAutoFollowPatternRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.resumeAutoFollowPatternAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getCcrStatsAsync(CcrStatsRequest request, RequestOptions options, final Handler<AsyncResult<CcrStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getCcrStatsAsync(request, options, (ActionListener)new ActionListener<CcrStatsResponse>(){

            public void onResponse(CcrStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getFollowStatsAsync(FollowStatsRequest request, RequestOptions options, final Handler<AsyncResult<FollowStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getFollowStatsAsync(request, options, (ActionListener)new ActionListener<FollowStatsResponse>(){

            public void onResponse(FollowStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getFollowInfoAsync(FollowInfoRequest request, RequestOptions options, final Handler<AsyncResult<FollowInfoResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getFollowInfoAsync(request, options, (ActionListener)new ActionListener<FollowInfoResponse>(){

            public void onResponse(FollowInfoResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

