/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.EqlClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.eql.EqlSearchRequest;
import org.elasticsearch.client.eql.EqlSearchResponse;
import org.elasticsearch.client.eql.EqlStatsRequest;
import org.elasticsearch.client.eql.EqlStatsResponse;

class EqlClientImpl
implements EqlClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.EqlClient delegate;

    EqlClientImpl(Vertx vertx, org.elasticsearch.client.EqlClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void searchAsync(EqlSearchRequest request, RequestOptions options, final Handler<AsyncResult<EqlSearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.searchAsync(request, options, (ActionListener)new ActionListener<EqlSearchResponse>(){

            public void onResponse(EqlSearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void statsAsync(EqlStatsRequest request, RequestOptions options, final Handler<AsyncResult<EqlStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.statsAsync(request, options, (ActionListener)new ActionListener<EqlStatsResponse>(){

            public void onResponse(EqlStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

