/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.GraphClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.graph.GraphExploreRequest;
import org.elasticsearch.client.graph.GraphExploreResponse;

class GraphClientImpl
implements GraphClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.GraphClient delegate;

    GraphClientImpl(Vertx vertx, org.elasticsearch.client.GraphClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void exploreAsync(GraphExploreRequest graphExploreRequest, RequestOptions options, final Handler<AsyncResult<GraphExploreResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.exploreAsync(graphExploreRequest, options, (ActionListener)new ActionListener<GraphExploreResponse>(){

            public void onResponse(GraphExploreResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

