/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.LicenseClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.license.DeleteLicenseRequest;
import org.elasticsearch.client.license.GetLicenseRequest;
import org.elasticsearch.client.license.GetLicenseResponse;
import org.elasticsearch.client.license.PutLicenseRequest;
import org.elasticsearch.client.license.PutLicenseResponse;
import org.elasticsearch.client.license.StartBasicRequest;
import org.elasticsearch.client.license.StartBasicResponse;
import org.elasticsearch.client.license.StartTrialRequest;
import org.elasticsearch.client.license.StartTrialResponse;

class LicenseClientImpl
implements LicenseClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.LicenseClient delegate;

    LicenseClientImpl(Vertx vertx, org.elasticsearch.client.LicenseClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putLicenseAsync(PutLicenseRequest request, RequestOptions options, final Handler<AsyncResult<PutLicenseResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putLicenseAsync(request, options, (ActionListener)new ActionListener<PutLicenseResponse>(){

            public void onResponse(PutLicenseResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getLicenseAsync(GetLicenseRequest request, RequestOptions options, final Handler<AsyncResult<GetLicenseResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getLicenseAsync(request, options, (ActionListener)new ActionListener<GetLicenseResponse>(){

            public void onResponse(GetLicenseResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteLicenseAsync(DeleteLicenseRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteLicenseAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void startTrialAsync(StartTrialRequest request, RequestOptions options, final Handler<AsyncResult<StartTrialResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.startTrialAsync(request, options, (ActionListener)new ActionListener<StartTrialResponse>(){

            public void onResponse(StartTrialResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void startBasicAsync(StartBasicRequest request, RequestOptions options, final Handler<AsyncResult<StartBasicResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.startBasicAsync(request, options, (ActionListener)new ActionListener<StartBasicResponse>(){

            public void onResponse(StartBasicResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

