/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.RollupClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.elasticsearch.client.rollup.GetRollupCapsResponse;
import org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import org.elasticsearch.client.rollup.GetRollupIndexCapsResponse;
import org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupJobResponse;
import org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.elasticsearch.client.rollup.StartRollupJobRequest;
import org.elasticsearch.client.rollup.StartRollupJobResponse;
import org.elasticsearch.client.rollup.StopRollupJobRequest;
import org.elasticsearch.client.rollup.StopRollupJobResponse;

class RollupClientImpl
implements RollupClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.RollupClient delegate;

    RollupClientImpl(Vertx vertx, org.elasticsearch.client.RollupClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putRollupJobAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void startRollupJobAsync(StartRollupJobRequest request, RequestOptions options, final Handler<AsyncResult<StartRollupJobResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.startRollupJobAsync(request, options, (ActionListener)new ActionListener<StartRollupJobResponse>(){

            public void onResponse(StartRollupJobResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void stopRollupJobAsync(StopRollupJobRequest request, RequestOptions options, final Handler<AsyncResult<StopRollupJobResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.stopRollupJobAsync(request, options, (ActionListener)new ActionListener<StopRollupJobResponse>(){

            public void onResponse(StopRollupJobResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteRollupJobAsync(DeleteRollupJobRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteRollupJobAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, final Handler<AsyncResult<GetRollupJobResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRollupJobAsync(request, options, (ActionListener)new ActionListener<GetRollupJobResponse>(){

            public void onResponse(GetRollupJobResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void searchAsync(SearchRequest request, RequestOptions options, final Handler<AsyncResult<SearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.searchAsync(request, options, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, final Handler<AsyncResult<GetRollupCapsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRollupCapabilitiesAsync(request, options, (ActionListener)new ActionListener<GetRollupCapsResponse>(){

            public void onResponse(GetRollupCapsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getRollupIndexCapabilitiesAsync(GetRollupIndexCapsRequest request, RequestOptions options, final Handler<AsyncResult<GetRollupIndexCapsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRollupIndexCapabilitiesAsync(request, options, (ActionListener)new ActionListener<GetRollupIndexCapsResponse>(){

            public void onResponse(GetRollupIndexCapsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

