/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.SecurityClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.security.AuthenticateResponse;
import org.elasticsearch.client.security.ChangePasswordRequest;
import org.elasticsearch.client.security.ClearApiKeyCacheRequest;
import org.elasticsearch.client.security.ClearPrivilegesCacheRequest;
import org.elasticsearch.client.security.ClearPrivilegesCacheResponse;
import org.elasticsearch.client.security.ClearRealmCacheRequest;
import org.elasticsearch.client.security.ClearRealmCacheResponse;
import org.elasticsearch.client.security.ClearRolesCacheRequest;
import org.elasticsearch.client.security.ClearRolesCacheResponse;
import org.elasticsearch.client.security.ClearSecurityCacheResponse;
import org.elasticsearch.client.security.CreateApiKeyRequest;
import org.elasticsearch.client.security.CreateApiKeyResponse;
import org.elasticsearch.client.security.CreateTokenRequest;
import org.elasticsearch.client.security.CreateTokenResponse;
import org.elasticsearch.client.security.DelegatePkiAuthenticationRequest;
import org.elasticsearch.client.security.DelegatePkiAuthenticationResponse;
import org.elasticsearch.client.security.DeletePrivilegesRequest;
import org.elasticsearch.client.security.DeletePrivilegesResponse;
import org.elasticsearch.client.security.DeleteRoleMappingRequest;
import org.elasticsearch.client.security.DeleteRoleMappingResponse;
import org.elasticsearch.client.security.DeleteRoleRequest;
import org.elasticsearch.client.security.DeleteRoleResponse;
import org.elasticsearch.client.security.DeleteUserRequest;
import org.elasticsearch.client.security.DeleteUserResponse;
import org.elasticsearch.client.security.DisableUserRequest;
import org.elasticsearch.client.security.EnableUserRequest;
import org.elasticsearch.client.security.GetApiKeyRequest;
import org.elasticsearch.client.security.GetApiKeyResponse;
import org.elasticsearch.client.security.GetBuiltinPrivilegesResponse;
import org.elasticsearch.client.security.GetPrivilegesRequest;
import org.elasticsearch.client.security.GetPrivilegesResponse;
import org.elasticsearch.client.security.GetRoleMappingsRequest;
import org.elasticsearch.client.security.GetRoleMappingsResponse;
import org.elasticsearch.client.security.GetRolesRequest;
import org.elasticsearch.client.security.GetRolesResponse;
import org.elasticsearch.client.security.GetSslCertificatesResponse;
import org.elasticsearch.client.security.GetUserPrivilegesResponse;
import org.elasticsearch.client.security.GetUsersRequest;
import org.elasticsearch.client.security.GetUsersResponse;
import org.elasticsearch.client.security.HasPrivilegesRequest;
import org.elasticsearch.client.security.HasPrivilegesResponse;
import org.elasticsearch.client.security.InvalidateApiKeyRequest;
import org.elasticsearch.client.security.InvalidateApiKeyResponse;
import org.elasticsearch.client.security.InvalidateTokenRequest;
import org.elasticsearch.client.security.InvalidateTokenResponse;
import org.elasticsearch.client.security.PutPrivilegesRequest;
import org.elasticsearch.client.security.PutPrivilegesResponse;
import org.elasticsearch.client.security.PutRoleMappingRequest;
import org.elasticsearch.client.security.PutRoleMappingResponse;
import org.elasticsearch.client.security.PutRoleRequest;
import org.elasticsearch.client.security.PutRoleResponse;
import org.elasticsearch.client.security.PutUserRequest;
import org.elasticsearch.client.security.PutUserResponse;

class SecurityClientImpl
implements SecurityClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.SecurityClient delegate;

    SecurityClientImpl(Vertx vertx, org.elasticsearch.client.SecurityClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void getUsersAsync(GetUsersRequest request, RequestOptions options, final Handler<AsyncResult<GetUsersResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getUsersAsync(request, options, (ActionListener)new ActionListener<GetUsersResponse>(){

            public void onResponse(GetUsersResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putUserAsync(PutUserRequest request, RequestOptions options, final Handler<AsyncResult<PutUserResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putUserAsync(request, options, (ActionListener)new ActionListener<PutUserResponse>(){

            public void onResponse(PutUserResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteUserAsync(DeleteUserRequest request, RequestOptions options, final Handler<AsyncResult<DeleteUserResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteUserAsync(request, options, (ActionListener)new ActionListener<DeleteUserResponse>(){

            public void onResponse(DeleteUserResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putRoleMappingAsync(PutRoleMappingRequest request, RequestOptions options, final Handler<AsyncResult<PutRoleMappingResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putRoleMappingAsync(request, options, (ActionListener)new ActionListener<PutRoleMappingResponse>(){

            public void onResponse(PutRoleMappingResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getRoleMappingsAsync(GetRoleMappingsRequest request, RequestOptions options, final Handler<AsyncResult<GetRoleMappingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRoleMappingsAsync(request, options, (ActionListener)new ActionListener<GetRoleMappingsResponse>(){

            public void onResponse(GetRoleMappingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void enableUserAsync(EnableUserRequest request, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.enableUserAsync(request, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void disableUserAsync(DisableUserRequest request, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.disableUserAsync(request, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void authenticateAsync(RequestOptions options, final Handler<AsyncResult<AuthenticateResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.authenticateAsync(options, (ActionListener)new ActionListener<AuthenticateResponse>(){

            public void onResponse(AuthenticateResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void hasPrivilegesAsync(HasPrivilegesRequest request, RequestOptions options, final Handler<AsyncResult<HasPrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.hasPrivilegesAsync(request, options, (ActionListener)new ActionListener<HasPrivilegesResponse>(){

            public void onResponse(HasPrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getUserPrivilegesAsync(RequestOptions options, final Handler<AsyncResult<GetUserPrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getUserPrivilegesAsync(options, (ActionListener)new ActionListener<GetUserPrivilegesResponse>(){

            public void onResponse(GetUserPrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearRealmCacheAsync(ClearRealmCacheRequest request, RequestOptions options, final Handler<AsyncResult<ClearRealmCacheResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearRealmCacheAsync(request, options, (ActionListener)new ActionListener<ClearRealmCacheResponse>(){

            public void onResponse(ClearRealmCacheResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearRolesCacheAsync(ClearRolesCacheRequest request, RequestOptions options, final Handler<AsyncResult<ClearRolesCacheResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearRolesCacheAsync(request, options, (ActionListener)new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearPrivilegesCacheAsync(ClearPrivilegesCacheRequest request, RequestOptions options, final Handler<AsyncResult<ClearPrivilegesCacheResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearPrivilegesCacheAsync(request, options, (ActionListener)new ActionListener<ClearPrivilegesCacheResponse>(){

            public void onResponse(ClearPrivilegesCacheResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearApiKeyCacheAsync(ClearApiKeyCacheRequest request, RequestOptions options, final Handler<AsyncResult<ClearSecurityCacheResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearApiKeyCacheAsync(request, options, (ActionListener)new ActionListener<ClearSecurityCacheResponse>(){

            public void onResponse(ClearSecurityCacheResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getSslCertificatesAsync(RequestOptions options, final Handler<AsyncResult<GetSslCertificatesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getSslCertificatesAsync(options, (ActionListener)new ActionListener<GetSslCertificatesResponse>(){

            public void onResponse(GetSslCertificatesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void changePasswordAsync(ChangePasswordRequest request, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.changePasswordAsync(request, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getRolesAsync(GetRolesRequest request, RequestOptions options, final Handler<AsyncResult<GetRolesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRolesAsync(request, options, (ActionListener)new ActionListener<GetRolesResponse>(){

            public void onResponse(GetRolesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putRoleAsync(PutRoleRequest request, RequestOptions options, final Handler<AsyncResult<PutRoleResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putRoleAsync(request, options, (ActionListener)new ActionListener<PutRoleResponse>(){

            public void onResponse(PutRoleResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteRoleMappingAsync(DeleteRoleMappingRequest request, RequestOptions options, final Handler<AsyncResult<DeleteRoleMappingResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteRoleMappingAsync(request, options, (ActionListener)new ActionListener<DeleteRoleMappingResponse>(){

            public void onResponse(DeleteRoleMappingResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteRoleAsync(DeleteRoleRequest request, RequestOptions options, final Handler<AsyncResult<DeleteRoleResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteRoleAsync(request, options, (ActionListener)new ActionListener<DeleteRoleResponse>(){

            public void onResponse(DeleteRoleResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createTokenAsync(CreateTokenRequest request, RequestOptions options, final Handler<AsyncResult<CreateTokenResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createTokenAsync(request, options, (ActionListener)new ActionListener<CreateTokenResponse>(){

            public void onResponse(CreateTokenResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void invalidateTokenAsync(InvalidateTokenRequest request, RequestOptions options, final Handler<AsyncResult<InvalidateTokenResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.invalidateTokenAsync(request, options, (ActionListener)new ActionListener<InvalidateTokenResponse>(){

            public void onResponse(InvalidateTokenResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getBuiltinPrivilegesAsync(RequestOptions options, final Handler<AsyncResult<GetBuiltinPrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getBuiltinPrivilegesAsync(options, (ActionListener)new ActionListener<GetBuiltinPrivilegesResponse>(){

            public void onResponse(GetBuiltinPrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getPrivilegesAsync(GetPrivilegesRequest request, RequestOptions options, final Handler<AsyncResult<GetPrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getPrivilegesAsync(request, options, (ActionListener)new ActionListener<GetPrivilegesResponse>(){

            public void onResponse(GetPrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putPrivilegesAsync(PutPrivilegesRequest request, RequestOptions options, final Handler<AsyncResult<PutPrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putPrivilegesAsync(request, options, (ActionListener)new ActionListener<PutPrivilegesResponse>(){

            public void onResponse(PutPrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deletePrivilegesAsync(DeletePrivilegesRequest request, RequestOptions options, final Handler<AsyncResult<DeletePrivilegesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deletePrivilegesAsync(request, options, (ActionListener)new ActionListener<DeletePrivilegesResponse>(){

            public void onResponse(DeletePrivilegesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createApiKeyAsync(CreateApiKeyRequest request, RequestOptions options, final Handler<AsyncResult<CreateApiKeyResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createApiKeyAsync(request, options, (ActionListener)new ActionListener<CreateApiKeyResponse>(){

            public void onResponse(CreateApiKeyResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getApiKeyAsync(GetApiKeyRequest request, RequestOptions options, final Handler<AsyncResult<GetApiKeyResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getApiKeyAsync(request, options, (ActionListener)new ActionListener<GetApiKeyResponse>(){

            public void onResponse(GetApiKeyResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void invalidateApiKeyAsync(InvalidateApiKeyRequest request, RequestOptions options, final Handler<AsyncResult<InvalidateApiKeyResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.invalidateApiKeyAsync(request, options, (ActionListener)new ActionListener<InvalidateApiKeyResponse>(){

            public void onResponse(InvalidateApiKeyResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void delegatePkiAuthenticationAsync(DelegatePkiAuthenticationRequest request, RequestOptions options, final Handler<AsyncResult<DelegatePkiAuthenticationResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.delegatePkiAuthenticationAsync(request, options, (ActionListener)new ActionListener<DelegatePkiAuthenticationResponse>(){

            public void onResponse(DelegatePkiAuthenticationResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

