/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.TasksClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.tasks.CancelTasksRequest;
import org.elasticsearch.client.tasks.CancelTasksResponse;
import org.elasticsearch.client.tasks.GetTaskRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;

class TasksClientImpl
implements TasksClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.TasksClient delegate;

    TasksClientImpl(Vertx vertx, org.elasticsearch.client.TasksClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void listAsync(ListTasksRequest request, RequestOptions options, final Handler<AsyncResult<ListTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.listAsync(request, options, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetTaskRequest request, RequestOptions options, final Handler<AsyncResult<Optional<GetTaskResponse>>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(request, options, (ActionListener)new ActionListener<Optional<GetTaskResponse>>(){

            public void onResponse(Optional<GetTaskResponse> value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void cancelAsync(CancelTasksRequest cancelTasksRequest, RequestOptions options, final Handler<AsyncResult<CancelTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.cancelAsync(cancelTasksRequest, options, (ActionListener)new ActionListener<CancelTasksResponse>(){

            public void onResponse(CancelTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

