/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.XPackClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.xpack.XPackInfoRequest;
import org.elasticsearch.client.xpack.XPackInfoResponse;
import org.elasticsearch.client.xpack.XPackUsageRequest;
import org.elasticsearch.client.xpack.XPackUsageResponse;

class XPackClientImpl
implements XPackClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.XPackClient delegate;

    XPackClientImpl(Vertx vertx, org.elasticsearch.client.XPackClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void infoAsync(XPackInfoRequest request, RequestOptions options, final Handler<AsyncResult<XPackInfoResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.infoAsync(request, options, (ActionListener)new ActionListener<XPackInfoResponse>(){

            public void onResponse(XPackInfoResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void usageAsync(XPackUsageRequest request, RequestOptions options, final Handler<AsyncResult<XPackUsageResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.usageAsync(request, options, (ActionListener)new ActionListener<XPackUsageResponse>(){

            public void onResponse(XPackUsageResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

