/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.AsyncSearchClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.asyncsearch.AsyncSearchResponse;
import org.elasticsearch.client.asyncsearch.DeleteAsyncSearchRequest;
import org.elasticsearch.client.asyncsearch.GetAsyncSearchRequest;
import org.elasticsearch.client.asyncsearch.SubmitAsyncSearchRequest;
import org.elasticsearch.client.core.AcknowledgedResponse;

class AsyncSearchClientImpl
implements AsyncSearchClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.AsyncSearchClient delegate;

    AsyncSearchClientImpl(Vertx vertx, org.elasticsearch.client.AsyncSearchClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void submitAsync(SubmitAsyncSearchRequest request, RequestOptions options, final Handler<AsyncResult<AsyncSearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.submitAsync(request, options, (ActionListener)new ActionListener<AsyncSearchResponse>(){

            public void onResponse(AsyncSearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetAsyncSearchRequest request, RequestOptions options, final Handler<AsyncResult<AsyncSearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(request, options, (ActionListener)new ActionListener<AsyncSearchResponse>(){

            public void onResponse(AsyncSearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAsync(DeleteAsyncSearchRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

