/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.ClusterClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.cluster.RemoteInfoRequest;
import org.elasticsearch.client.cluster.RemoteInfoResponse;
import org.elasticsearch.client.indices.ComponentTemplatesExistRequest;
import org.elasticsearch.client.indices.DeleteComponentTemplateRequest;
import org.elasticsearch.client.indices.GetComponentTemplatesRequest;
import org.elasticsearch.client.indices.GetComponentTemplatesResponse;
import org.elasticsearch.client.indices.PutComponentTemplateRequest;

class ClusterClientImpl
implements ClusterClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.ClusterClient delegate;

    ClusterClientImpl(Vertx vertx, org.elasticsearch.client.ClusterClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putSettingsAsync(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options, final Handler<AsyncResult<ClusterUpdateSettingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putSettingsAsync(clusterUpdateSettingsRequest, options, (ActionListener)new ActionListener<ClusterUpdateSettingsResponse>(){

            public void onResponse(ClusterUpdateSettingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getSettingsAsync(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options, final Handler<AsyncResult<ClusterGetSettingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getSettingsAsync(clusterGetSettingsRequest, options, (ActionListener)new ActionListener<ClusterGetSettingsResponse>(){

            public void onResponse(ClusterGetSettingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void healthAsync(ClusterHealthRequest healthRequest, RequestOptions options, final Handler<AsyncResult<ClusterHealthResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.healthAsync(healthRequest, options, (ActionListener)new ActionListener<ClusterHealthResponse>(){

            public void onResponse(ClusterHealthResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void remoteInfoAsync(RemoteInfoRequest request, RequestOptions options, final Handler<AsyncResult<RemoteInfoResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.remoteInfoAsync(request, options, (ActionListener)new ActionListener<RemoteInfoResponse>(){

            public void onResponse(RemoteInfoResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteComponentTemplateAsync(DeleteComponentTemplateRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteComponentTemplateAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putComponentTemplateAsync(PutComponentTemplateRequest putComponentTemplateRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putComponentTemplateAsync(putComponentTemplateRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getComponentTemplateAsync(GetComponentTemplatesRequest getComponentTemplatesRequest, RequestOptions options, final Handler<AsyncResult<GetComponentTemplatesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getComponentTemplateAsync(getComponentTemplatesRequest, options, (ActionListener)new ActionListener<GetComponentTemplatesResponse>(){

            public void onResponse(GetComponentTemplatesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsComponentTemplateAsync(ComponentTemplatesExistRequest componentTemplatesRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsComponentTemplateAsync(componentTemplatesRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

