/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.EnrichClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.enrich.DeletePolicyRequest;
import org.elasticsearch.client.enrich.ExecutePolicyRequest;
import org.elasticsearch.client.enrich.ExecutePolicyResponse;
import org.elasticsearch.client.enrich.GetPolicyRequest;
import org.elasticsearch.client.enrich.GetPolicyResponse;
import org.elasticsearch.client.enrich.PutPolicyRequest;
import org.elasticsearch.client.enrich.StatsRequest;
import org.elasticsearch.client.enrich.StatsResponse;

class EnrichClientImpl
implements EnrichClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.EnrichClient delegate;

    EnrichClientImpl(Vertx vertx, org.elasticsearch.client.EnrichClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putPolicyAsync(PutPolicyRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putPolicyAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deletePolicyAsync(DeletePolicyRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deletePolicyAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getPolicyAsync(GetPolicyRequest request, RequestOptions options, final Handler<AsyncResult<GetPolicyResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getPolicyAsync(request, options, (ActionListener)new ActionListener<GetPolicyResponse>(){

            public void onResponse(GetPolicyResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void statsAsync(StatsRequest request, RequestOptions options, final Handler<AsyncResult<StatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.statsAsync(request, options, (ActionListener)new ActionListener<StatsResponse>(){

            public void onResponse(StatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void executePolicyAsync(ExecutePolicyRequest request, RequestOptions options, final Handler<AsyncResult<ExecutePolicyResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.executePolicyAsync(request, options, (ActionListener)new ActionListener<ExecutePolicyResponse>(){

            public void onResponse(ExecutePolicyResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

