/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.IngestClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;

class IngestClientImpl
implements IngestClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.IngestClient delegate;

    IngestClientImpl(Vertx vertx, org.elasticsearch.client.IngestClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putPipelineAsync(PutPipelineRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putPipelineAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getPipelineAsync(GetPipelineRequest request, RequestOptions options, final Handler<AsyncResult<GetPipelineResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getPipelineAsync(request, options, (ActionListener)new ActionListener<GetPipelineResponse>(){

            public void onResponse(GetPipelineResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deletePipelineAsync(DeletePipelineRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deletePipelineAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void simulateAsync(SimulatePipelineRequest request, RequestOptions options, final Handler<AsyncResult<SimulatePipelineResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.simulateAsync(request, options, (ActionListener)new ActionListener<SimulatePipelineResponse>(){

            public void onResponse(SimulatePipelineResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

