/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.SnapshotClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;

class SnapshotClientImpl
implements SnapshotClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.SnapshotClient delegate;

    SnapshotClientImpl(Vertx vertx, org.elasticsearch.client.SnapshotClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void getRepositoryAsync(GetRepositoriesRequest getRepositoriesRequest, RequestOptions options, final Handler<AsyncResult<GetRepositoriesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getRepositoryAsync(getRepositoriesRequest, options, (ActionListener)new ActionListener<GetRepositoriesResponse>(){

            public void onResponse(GetRepositoriesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createRepositoryAsync(PutRepositoryRequest putRepositoryRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createRepositoryAsync(putRepositoryRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteRepositoryAsync(DeleteRepositoryRequest deleteRepositoryRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteRepositoryAsync(deleteRepositoryRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void verifyRepositoryAsync(VerifyRepositoryRequest verifyRepositoryRequest, RequestOptions options, final Handler<AsyncResult<VerifyRepositoryResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.verifyRepositoryAsync(verifyRepositoryRequest, options, (ActionListener)new ActionListener<VerifyRepositoryResponse>(){

            public void onResponse(VerifyRepositoryResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void cleanupRepositoryAsync(CleanupRepositoryRequest cleanupRepositoryRequest, RequestOptions options, final Handler<AsyncResult<CleanupRepositoryResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.cleanupRepositoryAsync(cleanupRepositoryRequest, options, (ActionListener)new ActionListener<CleanupRepositoryResponse>(){

            public void onResponse(CleanupRepositoryResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createAsync(CreateSnapshotRequest createSnapshotRequest, RequestOptions options, final Handler<AsyncResult<CreateSnapshotResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createAsync(createSnapshotRequest, options, (ActionListener)new ActionListener<CreateSnapshotResponse>(){

            public void onResponse(CreateSnapshotResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void cloneAsync(CloneSnapshotRequest cloneSnapshotRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.cloneAsync(cloneSnapshotRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetSnapshotsRequest getSnapshotsRequest, RequestOptions options, final Handler<AsyncResult<GetSnapshotsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(getSnapshotsRequest, options, (ActionListener)new ActionListener<GetSnapshotsResponse>(){

            public void onResponse(GetSnapshotsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void statusAsync(SnapshotsStatusRequest snapshotsStatusRequest, RequestOptions options, final Handler<AsyncResult<SnapshotsStatusResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.statusAsync(snapshotsStatusRequest, options, (ActionListener)new ActionListener<SnapshotsStatusResponse>(){

            public void onResponse(SnapshotsStatusResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void restoreAsync(RestoreSnapshotRequest restoreSnapshotRequest, RequestOptions options, final Handler<AsyncResult<RestoreSnapshotResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.restoreAsync(restoreSnapshotRequest, options, (ActionListener)new ActionListener<RestoreSnapshotResponse>(){

            public void onResponse(RestoreSnapshotResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAsync(DeleteSnapshotRequest deleteSnapshotRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAsync(deleteSnapshotRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

