/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.TransformClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.transform.DeleteTransformRequest;
import org.elasticsearch.client.transform.GetTransformRequest;
import org.elasticsearch.client.transform.GetTransformResponse;
import org.elasticsearch.client.transform.GetTransformStatsRequest;
import org.elasticsearch.client.transform.GetTransformStatsResponse;
import org.elasticsearch.client.transform.PreviewTransformRequest;
import org.elasticsearch.client.transform.PreviewTransformResponse;
import org.elasticsearch.client.transform.PutTransformRequest;
import org.elasticsearch.client.transform.StartTransformRequest;
import org.elasticsearch.client.transform.StartTransformResponse;
import org.elasticsearch.client.transform.StopTransformRequest;
import org.elasticsearch.client.transform.StopTransformResponse;
import org.elasticsearch.client.transform.UpdateTransformRequest;
import org.elasticsearch.client.transform.UpdateTransformResponse;

class TransformClientImpl
implements TransformClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.TransformClient delegate;

    TransformClientImpl(Vertx vertx, org.elasticsearch.client.TransformClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void putTransformAsync(PutTransformRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putTransformAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void updateTransformAsync(UpdateTransformRequest request, RequestOptions options, final Handler<AsyncResult<UpdateTransformResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.updateTransformAsync(request, options, (ActionListener)new ActionListener<UpdateTransformResponse>(){

            public void onResponse(UpdateTransformResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getTransformStatsAsync(GetTransformStatsRequest request, RequestOptions options, final Handler<AsyncResult<GetTransformStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getTransformStatsAsync(request, options, (ActionListener)new ActionListener<GetTransformStatsResponse>(){

            public void onResponse(GetTransformStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteTransformAsync(DeleteTransformRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteTransformAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void previewTransformAsync(PreviewTransformRequest request, RequestOptions options, final Handler<AsyncResult<PreviewTransformResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.previewTransformAsync(request, options, (ActionListener)new ActionListener<PreviewTransformResponse>(){

            public void onResponse(PreviewTransformResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void startTransformAsync(StartTransformRequest request, RequestOptions options, final Handler<AsyncResult<StartTransformResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.startTransformAsync(request, options, (ActionListener)new ActionListener<StartTransformResponse>(){

            public void onResponse(StartTransformResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void stopTransformAsync(StopTransformRequest request, RequestOptions options, final Handler<AsyncResult<StopTransformResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.stopTransformAsync(request, options, (ActionListener)new ActionListener<StopTransformResponse>(){

            public void onResponse(StopTransformResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getTransformAsync(GetTransformRequest request, RequestOptions options, final Handler<AsyncResult<GetTransformResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getTransformAsync(request, options, (ActionListener)new ActionListener<GetTransformResponse>(){

            public void onResponse(GetTransformResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

