/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.elasticsearch.client;

import io.reactiverse.elasticsearch.client.WatcherClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.watcher.AckWatchRequest;
import org.elasticsearch.client.watcher.AckWatchResponse;
import org.elasticsearch.client.watcher.ActivateWatchRequest;
import org.elasticsearch.client.watcher.ActivateWatchResponse;
import org.elasticsearch.client.watcher.DeactivateWatchRequest;
import org.elasticsearch.client.watcher.DeactivateWatchResponse;
import org.elasticsearch.client.watcher.DeleteWatchRequest;
import org.elasticsearch.client.watcher.DeleteWatchResponse;
import org.elasticsearch.client.watcher.ExecuteWatchRequest;
import org.elasticsearch.client.watcher.ExecuteWatchResponse;
import org.elasticsearch.client.watcher.GetWatchRequest;
import org.elasticsearch.client.watcher.GetWatchResponse;
import org.elasticsearch.client.watcher.PutWatchRequest;
import org.elasticsearch.client.watcher.PutWatchResponse;
import org.elasticsearch.client.watcher.StartWatchServiceRequest;
import org.elasticsearch.client.watcher.StopWatchServiceRequest;
import org.elasticsearch.client.watcher.WatcherStatsRequest;
import org.elasticsearch.client.watcher.WatcherStatsResponse;

class WatcherClientImpl
implements WatcherClient {
    private final Vertx vertx;
    private final org.elasticsearch.client.WatcherClient delegate;

    WatcherClientImpl(Vertx vertx, org.elasticsearch.client.WatcherClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void startWatchServiceAsync(StartWatchServiceRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.startWatchServiceAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void stopWatchServiceAsync(StopWatchServiceRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.stopWatchServiceAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putWatchAsync(PutWatchRequest request, RequestOptions options, final Handler<AsyncResult<PutWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putWatchAsync(request, options, (ActionListener)new ActionListener<PutWatchResponse>(){

            public void onResponse(PutWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getWatchAsync(GetWatchRequest request, RequestOptions options, final Handler<AsyncResult<GetWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getWatchAsync(request, options, (ActionListener)new ActionListener<GetWatchResponse>(){

            public void onResponse(GetWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deactivateWatchAsync(DeactivateWatchRequest request, RequestOptions options, final Handler<AsyncResult<DeactivateWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deactivateWatchAsync(request, options, (ActionListener)new ActionListener<DeactivateWatchResponse>(){

            public void onResponse(DeactivateWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteWatchAsync(DeleteWatchRequest request, RequestOptions options, final Handler<AsyncResult<DeleteWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteWatchAsync(request, options, (ActionListener)new ActionListener<DeleteWatchResponse>(){

            public void onResponse(DeleteWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void ackWatchAsync(AckWatchRequest request, RequestOptions options, final Handler<AsyncResult<AckWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.ackWatchAsync(request, options, (ActionListener)new ActionListener<AckWatchResponse>(){

            public void onResponse(AckWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void activateWatchAsync(ActivateWatchRequest request, RequestOptions options, final Handler<AsyncResult<ActivateWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.activateWatchAsync(request, options, (ActionListener)new ActionListener<ActivateWatchResponse>(){

            public void onResponse(ActivateWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void executeWatchAsync(ExecuteWatchRequest request, RequestOptions options, final Handler<AsyncResult<ExecuteWatchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.executeWatchAsync(request, options, (ActionListener)new ActionListener<ExecuteWatchResponse>(){

            public void onResponse(ExecuteWatchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void watcherStatsAsync(WatcherStatsRequest request, RequestOptions options, final Handler<AsyncResult<WatcherStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.watcherStatsAsync(request, options, (ActionListener)new ActionListener<WatcherStatsResponse>(){

            public void onResponse(WatcherStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

